/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.record;

import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.Box;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public final class MapRecord
extends IRecord {
    final TIntObjectMap<Object> values;

    public MapRecord(IFieldCollection fields) {
        super(fields);
        this.values = new TIntObjectHashMap<Object>(Math.min(fields.numOfFields(), 4));
    }

    @Override
    public MapRecord set(int index, Object value) {
        this.checkIndex(index);
        if (value == null) {
            if (this.values.containsKey(index)) {
                this.values.put(index, null);
            }
        } else {
            this.values.put(index, value);
        }
        return this;
    }

    @Override
    public MapRecord setFromBox(int index, Box<?, ?> source2) {
        this.checkIndex(index);
        if (source2 == null || source2.isNull()) {
            if (this.values.containsKey(index)) {
                this.values.put(index, null);
            }
        } else {
            this.values.put(index, source2.get());
        }
        return this;
    }

    @Override
    public <T> T get(int index) {
        this.checkIndex(index);
        return (T)this.values.get(index);
    }

    @Override
    public void setToBox(int index, Box<?, ?> source2) {
        this.checkIndex(index);
        if (this.values.containsKey(index)) {
            source2.set(this.get(index));
        } else {
            source2.init();
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public MapRecord clone() {
        MapRecord record = new MapRecord(this.keys);
        TIntIterator keys2 = this.values.keySet().iterator();
        while (keys2.hasNext()) {
            int key = keys2.next();
            Object value = this.values.get(key);
            if (value == null) continue;
            record.values.put(key, value);
        }
        return record;
    }
}

