/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.record;

import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.Box;
import java.util.Arrays;

public final class Record
extends IRecord {
    final Object[] values;

    public Record(IFieldCollection fields) {
        super(fields.asUnmodifiable());
        this.values = new Object[this.keys.numOfFields()];
    }

    @Override
    public Record set(int index, Object value) {
        this.values[index] = value;
        return this;
    }

    @Override
    public IRecord setFromBox(int index, Box<?, ?> source2) {
        this.values[index] = source2 == null ? null : source2.get();
        return this;
    }

    @Override
    public <T> T get(int index) {
        return (T)this.values[index];
    }

    @Override
    public void setToBox(int index, Box<?, ?> source2) {
        if (this.values[index] == null) {
            source2.init();
        } else {
            source2.set(this.get(index));
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
    }

    @Override
    public Record clone() {
        Record record = new Record(this.keys);
        System.arraycopy(this.values, 0, record.values, 0, this.values.length);
        return record;
    }
}

