/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.ccf.toolkit.listener.IListener;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.iterator.SingletonIterable;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.utils.Configurator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CCFSlidingPairwiseCalculator<T extends IReaderOption<T>, I, O, M> {
    final T input;
    final Function<BoxRecord, Iterable<I>> converter;
    final BiFunction<I, I, M> model;
    final OutputOption<M, O> output;
    IObjectObjectFilter<I, I> threshold = (obj1, obj2) -> true;
    IListener<T, OutputOption<M, O>> listener = IListener.EMPTY;
    Configurator<I> initializer = I -> {};
    Configurator<I> destroyer = I -> {};

    private CCFSlidingPairwiseCalculator(T input, Function<BoxRecord, Iterable<I>> converter, BiFunction<I, I, M> model, OutputOption<M, O> output) {
        this.input = input;
        this.converter = converter;
        this.model = model;
        this.output = output;
    }

    public static <T extends IReaderOption<T>> InputSetting<T, BoxRecord> setInput(T input) {
        return new InputSetting(input, SingletonIterable::new, null);
    }

    public static InputSetting<ReaderOption, BoxRecord> setInput(String file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption, BoxRecord>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), SingletonIterable::new, null);
        }
        return new InputSetting<ReaderOption, BoxRecord>(new ReaderOption(file, fields), SingletonIterable::new, null);
    }

    public static InputSetting<ReaderOption, BoxRecord> setInput(File file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption, BoxRecord>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), SingletonIterable::new, null);
        }
        return new InputSetting<ReaderOption, BoxRecord>(new ReaderOption(file, fields), SingletonIterable::new, null);
    }

    public static InputSetting<ReaderOption, BoxRecord> setInput(LiveFile file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption, BoxRecord>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), SingletonIterable::new, null);
        }
        return new InputSetting<ReaderOption, BoxRecord>(new ReaderOption(file, fields), SingletonIterable::new, null);
    }

    public static InputSetting<ReaderOption, BoxRecord> setInput(CCFTable table, String ... fields) {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption, BoxRecord>((IReaderOption)new ReaderOption(table, new String[0]).addAllFields(), SingletonIterable::new, null);
        }
        return new InputSetting<ReaderOption, BoxRecord>(new ReaderOption(table, fields), SingletonIterable::new, null);
    }

    public static <T extends IReaderOption<T>, I> InputSetting<T, I> setInput(T input, Function<BoxRecord, Iterable<I>> converter) {
        return new InputSetting(input, converter, null);
    }

    public CCFSlidingPairwiseCalculator<T, I, O, M> init(Configurator<I> initializer) {
        this.initializer = initializer == null ? I -> {} : initializer;
        return this;
    }

    public CCFSlidingPairwiseCalculator<T, I, O, M> destroy(Configurator<I> destroyer) {
        this.destroyer = destroyer == null ? I -> {} : destroyer;
        return this;
    }

    public CCFSlidingPairwiseCalculator<T, I, O, M> makeWindowsIf(IObjectObjectFilter<I, I> threshold) {
        this.threshold = threshold == null ? (obj1, obj2) -> true : threshold;
        return this;
    }

    public CCFSlidingPairwiseCalculator<T, I, O, M> setListener(IListener<T, OutputOption<M, O>> listener) {
        this.listener = listener == null ? IListener.EMPTY : listener;
        return this;
    }

    public void submit(int threads) throws IOException {
        threads = RuntimeProperty.verifyThreads(threads);
        List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
        OutputConsumer<M> writers = this.output.getWriters(readers.size());
        this.listener.start(this.input, this.output);
        AtomicLong pairs = new AtomicLong();
        AtomicLong reads = new AtomicLong();
        try (ThreadQueue pool = new ThreadQueue(threads);){
            int i = 0;
            while (i < readers.size()) {
                int threadIndex = i++;
                pool.addTask((status, context) -> {
                    CCFReader reader = (CCFReader)readers.get(threadIndex);
                    long maxPointer = reader.available().end() - 1L;
                    reader.limit(reader.available().start(), Long.MAX_VALUE);
                    List<Element<I>> windows = new List<Element<I>>();
                    BoxRecord container = reader.getRecord();
                    long readInCurrentThread = 0L;
                    long pairInCurrentThread = 0L;
                    block0: while (true) {
                        if (this.fill(reader, container, windows)) {
                            ++readInCurrentThread;
                            this.listener.step(this.input, this.output, 1L, 0L);
                            if (windows.fastGet((int)0).pointer > maxPointer) break;
                            if (windows.size() < 2 || this.threshold.filter(windows.fastGet((int)0).record, windows.fastLastGet((int)0).record)) continue;
                        }
                        if (windows.size() == 0) break;
                        if (windows.size() == 1) {
                            Element<I> element = windows.fastGet(0);
                            if (!element.isInit) break;
                            this.destroyer.configure(element.record);
                            break;
                        }
                        do {
                            Element<I> firstObject = windows.popFirst();
                            if (!firstObject.isInit) {
                                this.initializer.configure(firstObject.record);
                                firstObject.isInit = true;
                            }
                            for (Element<I> secondObject : windows) {
                                M score;
                                if (!this.threshold.filter(firstObject.record, secondObject.record)) break;
                                if (!secondObject.isInit) {
                                    this.initializer.configure(secondObject.record);
                                    secondObject.isInit = true;
                                }
                                if ((score = this.model.apply(firstObject.record, secondObject.record)) == null) continue;
                                int count = writers.write(threadIndex, score);
                                pairInCurrentThread += (long)count;
                                this.listener.step(this.input, this.output, 0L, count);
                            }
                            this.destroyer.configure(firstObject.record);
                            if (windows.fastGet((int)0).pointer > maxPointer) break block0;
                        } while (windows.size() != 1 && !this.threshold.filter(windows.fastGet((int)0).record, windows.fastLastGet((int)0).record));
                    }
                    reader.close();
                    windows.close();
                    pairs.addAndGet(pairInCurrentThread);
                    reads.addAndGet(readInCurrentThread);
                });
            }
        }
        writers.close();
        this.listener.stop(this.input, this.output, reads.get(), pairs.get());
    }

    private boolean fill(CCFReader reader, BoxRecord container, List<Element<I>> elements) throws IOException {
        boolean add = false;
        while (reader.read(container)) {
            long pointer = reader.tell() - 1L;
            Iterable<I> sources = this.converter.apply(container);
            if (sources != null) {
                for (I source2 : sources) {
                    if (source2 == null) continue;
                    elements.add(new Element<I>(source2, pointer));
                    add = true;
                }
            }
            if (!add) continue;
            return true;
        }
        return false;
    }

    /* synthetic */ CCFSlidingPairwiseCalculator(IReaderOption x0, Function x1, BiFunction x2, OutputOption x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    private static class Element<I> {
        final I record;
        final long pointer;
        boolean isInit = false;

        public Element(I record, long pointer) {
            this.record = record;
            this.pointer = pointer;
        }
    }

    public static class CalculationSetting<T extends IReaderOption<T>, I, M> {
        final T input;
        final Function<BoxRecord, Iterable<I>> converter;
        final BiFunction<I, I, M> model;

        private CalculationSetting(T input, Function<BoxRecord, Iterable<I>> converter, BiFunction<I, I, M> model) {
            this.input = input;
            this.converter = converter;
            this.model = model;
        }

        public <O> CCFSlidingPairwiseCalculator<T, I, O, M> setOutput(OutputOption<M, O> output) {
            return new CCFSlidingPairwiseCalculator((IReaderOption)this.input, this.converter, this.model, output, null);
        }

        /* synthetic */ CalculationSetting(IReaderOption x0, Function x1, BiFunction x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class InputSetting<T extends IReaderOption<T>, I> {
        final T input;
        final Function<BoxRecord, Iterable<I>> converter;

        private InputSetting(T input, Function<BoxRecord, Iterable<I>> converter) {
            this.input = input;
            this.converter = converter;
        }

        public <M> CalculationSetting<T, I, M> calculate(BiFunction<I, I, M> model) {
            return new CalculationSetting((IReaderOption)this.input, this.converter, model, null);
        }

        /* synthetic */ InputSetting(IReaderOption x0, Function x1, 1 x2) {
            this(x0, x1);
        }
    }
}

