/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.toolkit.listener.IConcatListener;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class FieldConcatenator {
    final Map<String, CCFTable> inputs;
    final File output;
    final ICCFMeta meta = new CCFMeta();
    final ICCFOptions options = new CCFOptions();
    IConcatListener<Map<String, CCFTable>, File> listener = IConcatListener.EMPTY;

    private FieldConcatenator(Map<String, CCFTable> inputs, File output) {
        this.inputs = inputs;
        this.output = output;
    }

    public static InputSetting addInput(String group, CCFTable table) {
        return new InputSetting(group, table);
    }

    public static InputSetting addInputs(Map<String, CCFTable> inputs) {
        return new InputSetting(inputs);
    }

    public FieldConcatenator dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public FieldConcatenator clearMeta() {
        this.meta.clear();
        return this;
    }

    public FieldConcatenator addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public FieldConcatenator addMeta(Iterable<CCFMetaItem> meta) {
        this.meta.adds(meta);
        return this;
    }

    public FieldConcatenator clearOptions() {
        this.options.clear();
        return this;
    }

    public FieldConcatenator addOption(CCFMetaItem option) {
        this.options.add(option);
        return this;
    }

    public FieldConcatenator addOptions(Iterable<CCFMetaItem> options) {
        this.options.adds(options);
        return this;
    }

    public FieldConcatenator setListener(IConcatListener<Map<String, CCFTable>, File> listener) {
        this.listener = listener == null ? IConcatListener.EMPTY : listener;
        return this;
    }

    public void submit() throws IOException {
        this.listener.start(this.inputs, this.output);
        long byteTotal = 0L;
        long fieldTotal = 0L;
        long recordTotal = -1L;
        ChannelWriterStream output = new ChannelWriterStream(RuntimeProperty.createTempFile());
        long length = MetaCodec.saveTo(this.meta, output);
        byteTotal += length;
        this.listener.step(Collections.EMPTY_MAP, this.output, length, 0L, 0L);
        length = OptionCodec.saveTo(this.options, (IWriterStream)output);
        byteTotal += length;
        this.listener.step(Collections.EMPTY_MAP, this.output, length, 0L, 0L);
        int groupIndex = 0;
        HashMap<String, CCFTable> wrapper = new HashMap<String, CCFTable>();
        for (String groupName : this.inputs.keySet()) {
            CCFTable table = this.inputs.get(groupName);
            wrapper.clear();
            wrapper.put(groupName, table);
            if (table != null && table.containsFieldGroup(groupName)) {
                if (recordTotal == -1L) {
                    recordTotal = table.numOfRecords();
                } else if (recordTotal != table.numOfRecords()) {
                    throw new CCFComponentException("Records in the input file are inconsistent with the required");
                }
                FieldGroupMeta group = table.getFieldGroup(groupName);
                length = FieldGroupMetaCodec.saveTo(groupIndex, group, output);
                byteTotal += length;
                this.listener.step(wrapper, this.output, length, 0L, 0L);
                ISeekableReaderStream reader = table.getFile().openAsBinary();
                CCFHeaders blocks = table.getFieldGroupBlocks(groupName);
                ByteStream temp = ByteStream.getThreadInstance();
                temp.putVarInt32(groupIndex);
                temp.putVarInt32(0);
                temp.putVarInt32(blocks.numOfBlocks());
                length = 0L;
                for (CCFHeader block : blocks) {
                    temp.putVarInt32(block.numOfRecords());
                    temp.putVarInt32(block.length());
                    length += (long)block.length();
                }
                output.write(FieldGroupDataCodec.getType().ordinal());
                output.writeLong((long)temp.length() + length, 8);
                output.write(temp.bytes(), temp.offset(), temp.length());
                byteTotal += (long)(temp.length() + 9);
                this.listener.step(wrapper, this.output, temp.length() + 9, 0L, 0L);
                for (CCFHeader block : blocks) {
                    int count = block.length();
                    reader.seek(block.tell());
                    while (count > 0) {
                        int byteToWrite = reader.read(temp.bytes(), 0, Math.min(temp.capacity(), count));
                        output.write(temp.bytes(), 0, byteToWrite);
                        count -= byteToWrite;
                        byteTotal += (long)byteToWrite;
                        this.listener.step(wrapper, this.output, byteToWrite, 0L, 0L);
                    }
                }
                reader.close();
                ++groupIndex;
                this.listener.step(wrapper, this.output, 0L, group.numOfFields(), recordTotal);
                fieldTotal += (long)group.numOfFields();
                continue;
            }
            this.listener.step(wrapper, this.output, 0L, 0L, 0L);
        }
        output.close();
        FileUtils.rename(output.getFile(), this.output);
        FileUtils.delete(output.getFile());
        this.listener.stop(this.inputs, this.output, byteTotal, fieldTotal, recordTotal == -1L ? 0L : recordTotal);
    }

    public static class InputSetting {
        final Map<String, CCFTable> inputs = new LinkedHashMap<String, CCFTable>();

        private InputSetting(String group, CCFTable input) {
            if (input != null) {
                this.inputs.put(group, input);
            }
        }

        private InputSetting(Map<String, CCFTable> inputs) {
            if (inputs != null) {
                this.inputs.putAll(inputs);
            }
        }

        public InputSetting addInput(String group, CCFTable table) {
            this.inputs.put(group, table);
            return this;
        }

        public InputSetting addInputs(Map<String, CCFTable> inputs) {
            if (inputs != null) {
                this.inputs.putAll(inputs);
            }
            return this;
        }

        public FieldConcatenator setOutput(String output) throws FileSystemException {
            if (output == null) {
                throw new IllegalArgumentException("Invalid output option: null");
            }
            return new FieldConcatenator(this.inputs, new File(output));
        }

        public FieldConcatenator setOutput(File output) throws FileSystemException {
            if (output == null) {
                throw new IllegalArgumentException("Invalid output option: null");
            }
            return new FieldConcatenator(this.inputs, output);
        }
    }
}

