/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.indexer.generics.Bucket;
import edu.sysu.pmglab.ccf.indexer.generics.BucketFlusher;
import edu.sysu.pmglab.ccf.indexer.generics.CCFIndexer;
import edu.sysu.pmglab.ccf.indexer.generics.DynamicCrudeBuckets;
import edu.sysu.pmglab.ccf.indexer.generics.RefinedBuckets;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.DynamicCrudeIntBuckets;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.indexer.longvalue.CCFLongIndexer;
import edu.sysu.pmglab.ccf.indexer.longvalue.DynamicCrudeLongBuckets;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.longvalue.RefinedLongBuckets;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.listener.IListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class Indexer {
    private Indexer() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    private static int getBlockFlusherSize(long numOfRecords) {
        if (numOfRecords < 0x100000L) {
            return 128;
        }
        if (numOfRecords <= 0x1000000L) {
            return 256;
        }
        if (numOfRecords <= 0x4000000L) {
            return 512;
        }
        if (numOfRecords <= 0x10000000L) {
            return 1024;
        }
        if (numOfRecords <= 0x40000000L) {
            return 2048;
        }
        if (numOfRecords <= 0x100000000L) {
            return 4096;
        }
        if (numOfRecords <= 0x400000000L) {
            return 8192;
        }
        if (numOfRecords <= 0x1000000000L) {
            return 16384;
        }
        if (numOfRecords <= 0x2000000000L) {
            return 32768;
        }
        if (numOfRecords <= 0x4000000000L) {
            return 65536;
        }
        return 131072;
    }

    public static <I extends IReaderOption<I>> InputSetting<I> setInput(I input) {
        return new InputSetting(input, null);
    }

    public static InputSetting<ReaderOption> setInput(String file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(File file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(LiveFile file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(CCFTable table, String ... fields) {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(table, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(table, fields), null);
    }

    public static class LongIndexSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final IFieldType tagType;
        final ToLongFunction<BoxRecord> valueGetter;
        final IFieldType valueType = FieldType.varInt64;
        LongBucketFlusher flusher;
        IListener<I, Void> listener = IListener.EMPTY;

        private LongIndexSetting(I input, Function<BoxRecord, T> tagGetter, IFieldType tagType, ToLongFunction<BoxRecord> valueGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.tagType = tagType;
            this.valueGetter = valueGetter;
            int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)input).numOfRecords());
            this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
        }

        public LongIndexSetting<I, T> buildBucketIf(LongBucketFlusher flusher) {
            if (flusher == null) {
                int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)this.input).numOfRecords());
                this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
            } else {
                this.flusher = flusher;
            }
            return this;
        }

        public LongIndexSetting<I, T> setListener(IListener<I, Void> listener) {
            this.listener = listener == null ? IListener.EMPTY : listener;
            return this;
        }

        public CCFLongIndexer<T> build(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            this.listener.start(this.input, null);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Object object = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap<T, DynamicCrudeLongBuckets> partialIndexer = new THashMap<T, DynamicCrudeLongBuckets>();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                long value = this.valueGetter.applyAsLong(record);
                                T lastTag = tag;
                                DynamicCrudeLongBuckets lastBuckets = new DynamicCrudeLongBuckets(this.flusher);
                                lastBuckets.update(value, reader.tell() - 1L);
                                partialIndexer.put(tag, lastBuckets);
                                this.listener.step(this.input, null, 1L, 1L);
                                while (reader.read(record)) {
                                    tag = this.tagGetter.apply(record);
                                    value = this.valueGetter.applyAsLong(record);
                                    if (!Objects.equals(tag, lastTag)) {
                                        lastTag = tag;
                                        if (!partialIndexer.containsKey(tag)) {
                                            lastBuckets = new DynamicCrudeLongBuckets(this.flusher);
                                            partialIndexer.put(tag, lastBuckets);
                                        } else {
                                            lastBuckets = (DynamicCrudeLongBuckets)partialIndexer.get(tag);
                                        }
                                    }
                                    lastBuckets.update(value, reader.tell() - 1L);
                                    this.listener.step(this.input, null, 1L, 1L);
                                }
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                for (Object tag : partialIndexer.keySet()) {
                                    if (!crudeBuckets.containsKey(tag)) {
                                        crudeBuckets.put(tag, new DynamicCrudeLongBuckets(this.flusher));
                                    }
                                    ((DynamicCrudeLongBuckets)crudeBuckets.get(tag)).update((DynamicCrudeLongBuckets)partialIndexer.get(tag));
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                object = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (object != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)object).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stop(this.input, null, ((IReaderOption)this.input).numOfRecords(), ((IReaderOption)this.input).numOfRecords());
            THashMap refinedBuckets = new THashMap();
            for (Object tag : crudeBuckets.keySet()) {
                refinedBuckets.put(tag, ((DynamicCrudeLongBuckets)crudeBuckets.get(tag)).refined());
            }
            LiteTable liteTable = new LiteTable("LONG_INDEXER").addField("TAG", this.tagType).addField("VALUE_START", this.valueType).addField("VALUE_END", this.valueType).addField("COUNT", FieldType.varInt64).addField("POINTER_START", FieldType.varInt64).addField("POINTER_END", FieldType.varInt64).addField("ORDERED", FieldType.bool);
            for (Object tag : refinedBuckets.keySet()) {
                for (LongBucket Bucket2 : (RefinedLongBuckets)refinedBuckets.get(tag)) {
                    liteTable.alloc(tag, Bucket2.getMinValue(), Bucket2.getMaxValue(), Bucket2.getCount(), Bucket2.getMinPointer(), Bucket2.getMaxPointer(), Bucket2.isOrdered());
                }
            }
            liteTable.sort(Comparator.comparingLong(o -> (Long)o.get("POINTER_START")));
            return new CCFLongIndexer(liteTable.asUnmodifiable());
        }

        public CCFLongIndexer<T> save(String key, int threads) throws IOException {
            if (((IReaderOption)this.input).getTable().getOptions().contains(key)) {
                throw new CCFComponentException("Duplicated option: " + key);
            }
            CCFLongIndexer<T> indexer = this.build(threads);
            if (((IReaderOption)this.input).getFile().getFileType() != FileType.LOCAL) {
                throw new FileSystemException("Readonly file stream: " + ((IReaderOption)this.input).getFile());
            }
            WriterStream appender = new WriterStream(((LocalFile)((IReaderOption)this.input).getFile()).getFile(), WriterStream.Option.APPEND);
            OptionCodec.saveTo(new CCFMetaItem(key, FieldType.litetable, indexer.toLiteTable()), (IWriterStream)appender);
            ((IWriterStream)appender).close();
            return indexer;
        }

        /* synthetic */ LongIndexSetting(IReaderOption x0, Function x1, IFieldType x2, ToLongFunction x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static class IntIndexSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final IFieldType tagType;
        final ToIntFunction<BoxRecord> valueGetter;
        final IFieldType valueType = FieldType.varInt32;
        IntBucketFlusher flusher;
        IListener<I, Void> listener = IListener.EMPTY;

        private IntIndexSetting(I input, Function<BoxRecord, T> tagGetter, IFieldType tagType, ToIntFunction<BoxRecord> valueGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.tagType = tagType;
            this.valueGetter = valueGetter;
            int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)input).numOfRecords());
            this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
        }

        public IntIndexSetting<I, T> buildBucketIf(IntBucketFlusher flusher) {
            if (flusher == null) {
                int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)this.input).numOfRecords());
                this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
            } else {
                this.flusher = flusher;
            }
            return this;
        }

        public IntIndexSetting<I, T> setListener(IListener<I, Void> listener) {
            this.listener = listener == null ? IListener.EMPTY : listener;
            return this;
        }

        public CCFIntIndexer<T> build(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            this.listener.start(this.input, null);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Object object = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap<T, DynamicCrudeIntBuckets> partialIndexer = new THashMap<T, DynamicCrudeIntBuckets>();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                int value = this.valueGetter.applyAsInt(record);
                                T lastTag = tag;
                                DynamicCrudeIntBuckets lastBuckets = new DynamicCrudeIntBuckets(this.flusher);
                                lastBuckets.update(value, reader.tell() - 1L);
                                partialIndexer.put(tag, lastBuckets);
                                this.listener.step(this.input, null, 1L, 1L);
                                while (reader.read(record)) {
                                    tag = this.tagGetter.apply(record);
                                    value = this.valueGetter.applyAsInt(record);
                                    if (!Objects.equals(tag, lastTag)) {
                                        lastTag = tag;
                                        if (!partialIndexer.containsKey(tag)) {
                                            lastBuckets = new DynamicCrudeIntBuckets(this.flusher);
                                            partialIndexer.put(tag, lastBuckets);
                                        } else {
                                            lastBuckets = (DynamicCrudeIntBuckets)partialIndexer.get(tag);
                                        }
                                    }
                                    lastBuckets.update(value, reader.tell() - 1L);
                                    this.listener.step(this.input, null, 1L, 1L);
                                }
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                for (Object tag : partialIndexer.keySet()) {
                                    if (!crudeBuckets.containsKey(tag)) {
                                        crudeBuckets.put(tag, new DynamicCrudeIntBuckets(this.flusher));
                                    }
                                    ((DynamicCrudeIntBuckets)crudeBuckets.get(tag)).update((DynamicCrudeIntBuckets)partialIndexer.get(tag));
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                object = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (object != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)object).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stop(this.input, null, ((IReaderOption)this.input).numOfRecords(), ((IReaderOption)this.input).numOfRecords());
            THashMap refinedBuckets = new THashMap();
            for (Object tag : crudeBuckets.keySet()) {
                refinedBuckets.put(tag, ((DynamicCrudeIntBuckets)crudeBuckets.get(tag)).refined());
            }
            LiteTable liteTable = new LiteTable("INT_INDEXER").addField("TAG", this.tagType).addField("VALUE_START", this.valueType).addField("VALUE_END", this.valueType).addField("COUNT", FieldType.varInt64).addField("POINTER_START", FieldType.varInt64).addField("POINTER_END", FieldType.varInt64).addField("ORDERED", FieldType.bool);
            for (Object tag : refinedBuckets.keySet()) {
                for (IntBucket Bucket2 : (RefinedIntBuckets)refinedBuckets.get(tag)) {
                    liteTable.alloc(tag, Bucket2.getMinValue(), Bucket2.getMaxValue(), Bucket2.getCount(), Bucket2.getMinPointer(), Bucket2.getMaxPointer(), Bucket2.isOrdered());
                }
            }
            liteTable.sort(Comparator.comparingLong(o -> (Long)o.get("POINTER_START")));
            return new CCFIntIndexer(liteTable.asUnmodifiable());
        }

        public CCFIntIndexer<T> save(String key, int threads) throws IOException {
            if (((IReaderOption)this.input).getTable().getOptions().contains(key)) {
                throw new CCFComponentException("Duplicated option: " + key);
            }
            CCFIntIndexer<T> indexer = this.build(threads);
            if (((IReaderOption)this.input).getFile().getFileType() != FileType.LOCAL) {
                throw new FileSystemException("Readonly file stream: " + ((IReaderOption)this.input).getFile());
            }
            WriterStream appender = new WriterStream(((LocalFile)((IReaderOption)this.input).getFile()).getFile(), WriterStream.Option.APPEND);
            OptionCodec.saveTo(new CCFMetaItem(key, FieldType.litetable, indexer.toLiteTable()), (IWriterStream)appender);
            ((IWriterStream)appender).close();
            return indexer;
        }

        /* synthetic */ IntIndexSetting(IReaderOption x0, Function x1, IFieldType x2, ToIntFunction x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static class IndexSetting<I extends IReaderOption<I>, T, V extends Comparable<V>> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final IFieldType tagType;
        final Function<BoxRecord, V> valueGetter;
        final IFieldType valueType;
        BucketFlusher<V> flusher;
        IListener<I, Void> listener = IListener.EMPTY;

        private IndexSetting(I input, Function<BoxRecord, T> tagGetter, IFieldType tagType, Function<BoxRecord, V> valueGetter, IFieldType valueType) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.tagType = tagType;
            this.valueGetter = valueGetter;
            this.valueType = valueType;
            int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)input).numOfRecords());
            this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
        }

        public IndexSetting<I, T, V> buildBucketIf(BucketFlusher<V> flusher) {
            if (flusher == null) {
                int flusherSize = Indexer.getBlockFlusherSize(((IReaderOption)this.input).numOfRecords());
                this.flusher = (bucket, value, pointer) -> bucket.getCount() >= (long)flusherSize;
            } else {
                this.flusher = flusher;
            }
            return this;
        }

        public IndexSetting<I, T, V> setListener(IListener<I, Void> listener) {
            this.listener = listener == null ? IListener.EMPTY : listener;
            return this;
        }

        public CCFIndexer<T, V> build(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            this.listener.start(this.input, null);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Object object = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap<T, DynamicCrudeBuckets<V>> partialIndexer = new THashMap<T, DynamicCrudeBuckets<V>>();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                Comparable value = (Comparable)this.valueGetter.apply(record);
                                T lastTag = tag;
                                DynamicCrudeBuckets<Comparable> lastBuckets = new DynamicCrudeBuckets<Comparable>(this.flusher);
                                partialIndexer.put(tag, lastBuckets);
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.step(this.input, null, 1L, 1L);
                                while (reader.read(record)) {
                                    tag = this.tagGetter.apply(record);
                                    value = (Comparable)this.valueGetter.apply(record);
                                    if (!Objects.equals(tag, lastTag)) {
                                        lastTag = tag;
                                        if (!partialIndexer.containsKey(tag)) {
                                            lastBuckets = new DynamicCrudeBuckets<Comparable>(this.flusher);
                                            partialIndexer.put(tag, lastBuckets);
                                        } else {
                                            lastBuckets = (DynamicCrudeBuckets<Comparable>)partialIndexer.get(tag);
                                        }
                                    }
                                    lastBuckets.update(value, reader.tell() - 1L);
                                    this.listener.step(this.input, null, 1L, 1L);
                                }
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                for (Object tag : partialIndexer.keySet()) {
                                    if (!crudeBuckets.containsKey(tag)) {
                                        crudeBuckets.put(tag, new DynamicCrudeBuckets<V>(this.flusher));
                                    }
                                    ((DynamicCrudeBuckets)crudeBuckets.get(tag)).update((DynamicCrudeBuckets)partialIndexer.get(tag));
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                object = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (object != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)object).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stop(this.input, null, ((IReaderOption)this.input).numOfRecords(), ((IReaderOption)this.input).numOfRecords());
            THashMap refinedBuckets = new THashMap();
            for (Object tag : crudeBuckets.keySet()) {
                refinedBuckets.put(tag, ((DynamicCrudeBuckets)crudeBuckets.get(tag)).refined());
            }
            LiteTable liteTable = new LiteTable("INDEXER").addField("TAG", this.tagType).addField("VALUE_START", this.valueType).addField("VALUE_END", this.valueType).addField("COUNT", FieldType.varInt64).addField("POINTER_START", FieldType.varInt64).addField("POINTER_END", FieldType.varInt64).addField("ORDERED", FieldType.bool);
            for (Object tag : refinedBuckets.keySet()) {
                for (Bucket Bucket2 : (RefinedBuckets)refinedBuckets.get(tag)) {
                    liteTable.alloc(tag, Bucket2.getMinValue(), Bucket2.getMaxValue(), Bucket2.getCount(), Bucket2.getMinPointer(), Bucket2.getMaxPointer(), Bucket2.isOrdered());
                }
            }
            liteTable.sort(Comparator.comparingLong(o -> (Long)o.get("POINTER_START")));
            return new CCFIndexer(liteTable.asUnmodifiable());
        }

        public CCFIndexer<T, V> save(String key, int threads) throws IOException {
            if (((IReaderOption)this.input).getTable().getOptions().contains(key)) {
                throw new CCFComponentException("Duplicated option: " + key);
            }
            CCFIndexer<T, V> indexer = this.build(threads);
            if (((IReaderOption)this.input).getFile().getFileType() != FileType.LOCAL) {
                throw new FileSystemException("Readonly file stream: " + ((IReaderOption)this.input).getFile());
            }
            WriterStream appender = new WriterStream(((LocalFile)((IReaderOption)this.input).getFile()).getFile(), WriterStream.Option.APPEND);
            OptionCodec.saveTo(new CCFMetaItem(key, FieldType.litetable, indexer.toLiteTable()), (IWriterStream)appender);
            ((IWriterStream)appender).close();
            return indexer;
        }

        /* synthetic */ IndexSetting(IReaderOption x0, Function x1, IFieldType x2, Function x3, IFieldType x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static class TagSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final IFieldType tagType;

        private TagSetting(I input, Function<BoxRecord, T> tagGetter, IFieldType tagType) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.tagType = tagType;
        }

        public <V extends Comparable<V>> IndexSetting<I, T, V> getValueFrom(Function<BoxRecord, V> valueGetter, IFieldType valueType) {
            return new IndexSetting((IReaderOption)this.input, this.tagGetter, this.tagType, valueGetter, valueType, null);
        }

        public IntIndexSetting<I, T> getIntValueFrom(ToIntFunction<BoxRecord> valueGetter) {
            return new IntIndexSetting((IReaderOption)this.input, this.tagGetter, this.tagType, valueGetter, null);
        }

        public LongIndexSetting<I, T> getLongValueFrom(ToLongFunction<BoxRecord> valueGetter) {
            return new LongIndexSetting((IReaderOption)this.input, this.tagGetter, this.tagType, valueGetter, null);
        }

        /* synthetic */ TagSetting(IReaderOption x0, Function x1, IFieldType x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class InputSetting<I extends IReaderOption<I>> {
        final I input;

        private InputSetting(I input) {
            this.input = input;
        }

        public <T> TagSetting<I, T> getTagFrom(Function<BoxRecord, T> tagGetter, IFieldType tagType) {
            return new TagSetting((IReaderOption)this.input, tagGetter, tagType, null);
        }

        /* synthetic */ InputSetting(IReaderOption x0, 1 x1) {
            this(x0);
        }
    }
}

