/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.entry.TLongObjectEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.executor.ThreadQueue;
import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;

public class Query
implements AutoCloseable,
Closeable {
    static final Comparator<TLongObjectEntry<IRecord>> POINYTER_COMPARATOR = Comparator.comparingLong(TLongObjectEntry::getKey);
    final ThreadQueue queue;
    final CCFReader reader;
    final List<CCFReader> indexers;

    public Query(IReaderOption<?> indexer, int threads) throws IOException {
        threads = Math.max(1, threads);
        this.reader = new CCFReader(indexer.getTable());
        this.queue = new ThreadQueue(threads);
        this.indexers = new CCFReader(indexer).part(threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TLongObjectEntry<IRecord>> search(IFilter<BoxRecord> rule, int max) throws IOException {
        if (rule == null || max <= 0) {
            return List.EMPTY();
        }
        LongList results = new LongList();
        List<CCFReader> list = this.indexers;
        synchronized (list) {
            int i = 0;
            while (i < this.queue.getThreads()) {
                int threadID = i++;
                this.queue.addTask((status, context) -> {
                    CCFReader reader = this.indexers.fastGet(threadID);
                    reader.seek(0L);
                    BoxRecord record = reader.getRecord();
                    while (reader.read(record)) {
                        if (rule.filter(record)) {
                            LongList longList = results;
                            synchronized (longList) {
                                if (results.size() >= max) {
                                    break;
                                }
                                results.add(reader.tell() - 1L);
                            }
                        }
                        if (results.size() < max) continue;
                        break;
                    }
                });
            }
            this.queue.await();
        }
        if (results.size() == 0) {
            return List.EMPTY();
        }
        results.sort();
        List<TLongObjectEntry<IRecord>> returns = new List<TLongObjectEntry<IRecord>>();
        CCFReader cCFReader = this.reader;
        synchronized (cCFReader) {
            for (int pIndex = 0; pIndex < results.size(); ++pIndex) {
                long pointer = results.fastGet(pIndex);
                this.reader.seek(pointer);
                returns.add(new TLongObjectEntry<IRecord>(pointer, this.reader.read()));
            }
        }
        returns.sort(POINYTER_COMPARATOR);
        return returns.asUnmodifiable();
    }

    @Override
    public final void close() throws IOException {
        this.queue.close();
        this.reader.close();
        for (CCFReader reader : this.indexers) {
            reader.close();
        }
        this.indexers.close();
    }
}

