/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RecordConcatenator {
    final File file;
    final ChannelWriterStream writer;
    final FieldGroupMetas fields = new FieldGroupMetas();
    final ICCFMeta meta = new CCFMeta();
    final ICCFOptions options = new CCFOptions();
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicInteger chunkIndex = new AtomicInteger(0);

    public RecordConcatenator(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Illegal file path: null");
        }
        if (file.isDirectory()) {
            throw new FileSystemException(file + " Is a directory");
        }
        this.writer = new ChannelWriterStream(RuntimeProperty.createTempFile());
        this.file = file;
    }

    public RecordConcatenator(String path) throws IOException {
        this(new File(path));
    }

    public RecordConcatenator append(CCFTable table) throws IOException {
        if (!this.tryAppend(table)) {
            throw new CCFComponentException("Fields in the input file are inconsistent with the required" + table.getFile());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAppend(CCFTable table) throws IOException {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            if (this.fields.isModifiable()) {
                this.fields.asUnmodifiable();
                FieldGroupMetaCodec.saveTo(this.fields, this.writer);
            }
            if (table != null && table.numOfRecords() > 0L) {
                for (String group : this.fields.getAllFieldGroupNames()) {
                    if (table.containsFieldGroup(group) && table.getFieldGroup(group).equals(this.fields.getFieldGroup(group))) continue;
                    return false;
                }
                ISeekableReaderStream reader = table.getFile().openAsBinary();
                int groupIndex = 0;
                for (String groupName : this.fields.getAllFieldGroupNames()) {
                    CCFHeaders blocks = table.getFieldGroupBlocks(groupName);
                    ByteStream temp = ByteStream.getThreadInstance();
                    temp.putVarInt32(groupIndex);
                    temp.putVarInt32(this.chunkIndex.get());
                    temp.putVarInt32(blocks.numOfBlocks());
                    long length = 0L;
                    for (CCFHeader block : blocks) {
                        temp.putVarInt32(block.numOfRecords());
                        temp.putVarInt32(block.length());
                        length += (long)block.length();
                    }
                    this.writer.write(FieldGroupDataCodec.getType().ordinal());
                    this.writer.writeLong((long)temp.length() + length, 8);
                    this.writer.write(temp.bytes(), temp.offset(), temp.length());
                    for (CCFHeader block : blocks) {
                        int byteToWrite;
                        reader.seek(block.tell());
                        for (int count = block.length(); count > 0; count -= byteToWrite) {
                            byteToWrite = reader.read(temp.bytes(), 0, Math.min(temp.capacity(), count));
                            this.writer.write(temp.bytes(), 0, byteToWrite);
                        }
                    }
                    ++groupIndex;
                }
                reader.close();
                this.chunkIndex.getAndIncrement();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addField(FieldMeta field) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.fields.addField(field);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addField(String name, IFieldType type) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.fields.addField(name, type);
        }
        return this;
    }

    public RecordConcatenator addField(String group, String name, IFieldType type) {
        return this.addField(FieldMeta.of(group, name, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addFields(Iterable<FieldMeta> fields) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.fields.addFields((Iterable)fields);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator clearFields() {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.fields.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator dropDuplicateMeta() {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.meta.dropDuplicates();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator clearMeta() {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.meta.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addMeta(CCFMetaItem meta) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.meta.add(meta);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addMeta(Iterable<CCFMetaItem> meta) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.meta.adds(meta);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator clearOptions() {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.options.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addOption(CCFMetaItem option) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.options.add(option);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordConcatenator addOptions(Iterable<CCFMetaItem> options) {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                throw new IllegalStateException("IO Stream closed");
            }
            this.options.adds(options);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        RecordConcatenator recordConcatenator = this;
        synchronized (recordConcatenator) {
            if (this.closed.get()) {
                return;
            }
            this.append(null);
            this.closed.set(true);
            MetaCodec.saveTo(this.meta, this.writer);
            OptionCodec.saveTo(this.options, (IWriterStream)this.writer);
            this.writer.close();
            FileUtils.rename(this.writer.getFile(), this.file);
            FileUtils.delete(this.writer.getFile());
        }
    }
}

