/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.ccf.toolkit.filter.IObjectObjectFilter;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.objectpool.Producer;
import edu.sysu.pmglab.utils.Configurator;
import java.util.function.BiFunction;

public class SlidingPairwiseCalculator<I, M> {
    final BiFunction<I, I, M> model;
    final IObjectObjectFilter<I, I> threshold;
    final Producer<Iterable<I>> source;
    final List<Element<I>> windows = new List();
    Configurator<I> initializer = I -> {};
    Configurator<I> destroyer = I -> {};
    Element<I> current;
    int index = 0;

    private SlidingPairwiseCalculator(BiFunction<I, I, M> model, IObjectObjectFilter<I, I> threshold, Producer<Iterable<I>> sources) {
        this.model = model;
        this.threshold = threshold;
        this.source = sources;
    }

    public static <I, M> ModelSetting<I, M> setModel(BiFunction<I, I, M> model) {
        return new ModelSetting(model);
    }

    public SlidingPairwiseCalculator<I, M> init(Configurator<I> initializer) {
        this.initializer = initializer == null ? I -> {} : initializer;
        return this;
    }

    public SlidingPairwiseCalculator<I, M> destroy(Configurator<I> destroyer) {
        this.destroyer = destroyer == null ? I -> {} : destroyer;
        return this;
    }

    private boolean fill() {
        boolean add = false;
        do {
            Iterable<I> elements;
            if ((elements = this.source.offer()) == null) {
                return false;
            }
            for (I source2 : elements) {
                if (source2 == null) continue;
                this.windows.add(new Element<I>(source2));
                add = true;
            }
        } while (!add);
        return true;
    }

    public M next() {
        while (true) {
            if (this.current == null) {
                if (this.windows.size() > 0) {
                    this.current = this.windows.popFirst();
                } else {
                    if (!this.fill()) {
                        return null;
                    }
                    this.current = this.windows.popFirst();
                }
                this.index = 0;
                while ((this.windows.size() == 0 || this.threshold.filter(this.current.record, this.windows.fastLastGet((int)0).record)) && this.fill()) {
                }
            }
            if (this.index == this.windows.size()) {
                if (this.current.isInit) {
                    this.destroyer.configure(this.current.record);
                }
                this.current = null;
                continue;
            }
            if (!this.current.isInit) {
                this.initializer.configure(this.current.record);
                this.current.isInit = true;
            }
            Element<I> second = this.windows.fastGet(this.index);
            ++this.index;
            if (this.threshold.filter(this.current.record, second.record)) {
                M result;
                if (!second.isInit) {
                    this.initializer.configure(second.record);
                    second.isInit = true;
                }
                if ((result = this.model.apply(this.current.record, second.record)) == null) continue;
                return result;
            }
            if (this.current.isInit) {
                this.destroyer.configure(this.current.record);
            }
            this.current = null;
        }
    }

    private static class Element<I> {
        final I record;
        boolean isInit = false;

        public Element(I record) {
            this.record = record;
        }
    }

    public static class ModelSetting<I, M> {
        final BiFunction<I, I, M> model;
        IObjectObjectFilter<I, I> threshold = (obj1, obj2) -> true;

        private ModelSetting(BiFunction<I, I, M> model) {
            this.model = model;
        }

        public ModelSetting<I, M> makeWindowsIf(IObjectObjectFilter<I, I> threshold) {
            this.threshold = threshold == null ? (obj1, obj2) -> true : threshold;
            return this;
        }

        public SlidingPairwiseCalculator<I, M> setInput(Producer<Iterable<I>> input) {
            return new SlidingPairwiseCalculator(this.model, this.threshold, input);
        }
    }
}

