/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.indexer.generics.Bucket;
import edu.sysu.pmglab.ccf.indexer.generics.BucketFlusher;
import edu.sysu.pmglab.ccf.indexer.generics.DynamicCrudeBuckets;
import edu.sysu.pmglab.ccf.indexer.generics.FixedCrudeBuckets;
import edu.sysu.pmglab.ccf.indexer.generics.RefinedBuckets;
import edu.sysu.pmglab.ccf.indexer.intvalue.DynamicCrudeIntBuckets;
import edu.sysu.pmglab.ccf.indexer.intvalue.FixedCrudeIntBuckets;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.indexer.longvalue.DynamicCrudeLongBuckets;
import edu.sysu.pmglab.ccf.indexer.longvalue.FixedCrudeLongBuckets;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.longvalue.RefinedLongBuckets;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.listener.ISortListener;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.function.TIntFunction;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class Sorter {
    private Sorter() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static <I extends IReaderOption<I>> InputSetting<I> setInput(I input) {
        return new InputSetting(input, null);
    }

    public static InputSetting<ReaderOption> setInput(String file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(File file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(LiveFile file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(file, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(file, fields), null);
    }

    public static InputSetting<ReaderOption> setInput(CCFTable table, String ... fields) {
        if (fields.length == 0) {
            return new InputSetting<ReaderOption>((IReaderOption)new ReaderOption(table, new String[0]).addAllFields(), null);
        }
        return new InputSetting<ReaderOption>(new ReaderOption(table, fields), null);
    }

    public static class LongSorterSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final ToLongFunction<BoxRecord> valueGetter;
        ISortListener<I, OutputOption<IRecord, ?>> listener = ISortListener.EMPTY;
        int minRefinedBucketSize = 1024;
        int maxRefinedBucketSize = 0x200000;
        int bufferSize = 65536;
        ToIntFunction<Long> projection = value -> 0;

        private LongSorterSetting(I input, Function<BoxRecord, T> tagGetter, ToLongFunction<BoxRecord> valueGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.valueGetter = valueGetter;
        }

        public LongSorterSetting<I, T> setMinBucketSize(int size) {
            this.minRefinedBucketSize = ValueUtils.valueOf(size, 2, 0x10000000);
            return this;
        }

        public LongSorterSetting<I, T> setMaxBucketSize(int size) {
            this.maxRefinedBucketSize = ValueUtils.valueOf(size, 128, 0x10000000);
            return this;
        }

        public LongSorterSetting<I, T> setBufferSize(int size) {
            this.bufferSize = ValueUtils.valueOf(size, 64, 0x10000000);
            return this;
        }

        public LongSorterSetting<I, T> projectValue(ToIntFunction<Long> projection) {
            this.projection = projection == null ? value -> 0 : projection;
            return this;
        }

        public LongSorterSetting<I, T> setListener(ISortListener<I, OutputOption<IRecord, ?>> listener) {
            this.listener = listener == null ? ISortListener.EMPTY : listener;
            return this;
        }

        public boolean isOrdered(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            LinkedHashMap crudeBuckets = new LinkedHashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            LongBucketFlusher flusher = (bucket, value, pointer) -> bucket.getCount() >= 4096L;
            AtomicBoolean ordered = new AtomicBoolean(true);
            this.listener.startCrudeIndex(this.input);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Iterator iterator2 = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap<T, DynamicCrudeLongBuckets> partialIndexer = new THashMap<T, DynamicCrudeLongBuckets>();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                long value = this.valueGetter.applyAsLong(record);
                                T lastTag = tag;
                                long lastValue = value;
                                DynamicCrudeLongBuckets lastBuckets = new DynamicCrudeLongBuckets(flusher);
                                partialIndexer.put(tag, lastBuckets);
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                if (ordered.get()) {
                                    for (Object tag : partialIndexer.keySet()) {
                                        if (!crudeBuckets.containsKey(tag)) {
                                            crudeBuckets.put(tag, new DynamicCrudeLongBuckets(flusher));
                                        }
                                        ((DynamicCrudeLongBuckets)crudeBuckets.get(tag)).update((DynamicCrudeLongBuckets)partialIndexer.get(tag));
                                    }
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                iterator2 = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (iterator2 != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)((Object)iterator2)).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stopCrudeIndex(this.input);
            if (ordered.get()) {
                LinkedHashMap indexer = new LinkedHashMap();
                for (Object tag : crudeBuckets.keySet()) {
                    indexer.put(tag, ((DynamicCrudeLongBuckets)crudeBuckets.get(tag)).refined());
                }
                for (RefinedLongBuckets buckets : indexer.values()) {
                    if (buckets.isOrdered() && buckets.isCompact()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void bucketSort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    THashMap<T, FixedCrudeLongBuckets> threadCrudeBucket = new THashMap<T, FixedCrudeLongBuckets>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord record = reader.getRecord();
                        if (reader.read(record)) {
                            T tag = this.tagGetter.apply(record);
                            long value = this.valueGetter.applyAsLong(record);
                            T lastTag = tag;
                            FixedCrudeLongBuckets lastBuckets = new FixedCrudeLongBuckets(this.projection);
                            threadCrudeBucket.put(tag, lastBuckets);
                            lastBuckets.update(value, reader.tell() - 1L);
                            this.listener.crudeIndex(this.input, 1);
                            while (reader.read(record)) {
                                tag = this.tagGetter.apply(record);
                                value = this.valueGetter.applyAsLong(record);
                                if (!Objects.equals(tag, lastTag)) {
                                    lastTag = tag;
                                    if (!threadCrudeBucket.containsKey(tag)) {
                                        lastBuckets = new FixedCrudeLongBuckets(this.projection);
                                        threadCrudeBucket.put(tag, lastBuckets);
                                    } else {
                                        lastBuckets = (FixedCrudeLongBuckets)threadCrudeBucket.get(tag);
                                    }
                                }
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                        }
                    }
                    catch (Throwable record) {
                        object = record;
                        throw record;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable record) {
                                    ((Throwable)object).addSuppressed(record);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (threadCrudeBucket.size() != 0) {
                        Map map = crudeBuckets;
                        synchronized (map) {
                            for (Object tag : threadCrudeBucket.keySet()) {
                                FixedCrudeLongBuckets bucket = (FixedCrudeLongBuckets)threadCrudeBucket.get(tag);
                                if (!crudeBuckets.containsKey(tag)) {
                                    crudeBuckets.put(tag, new FixedCrudeLongBuckets(this.projection));
                                }
                                ((FixedCrudeLongBuckets)crudeBuckets.get(tag)).update((FixedCrudeLongBuckets)threadCrudeBucket.get(tag));
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            List<TEntry> taskRefinedBuckets = new List<TEntry>();
            for (Object tag : crudeBuckets.keySet()) {
                for (LongBucket intBucket : ((FixedCrudeLongBuckets)crudeBuckets.get(tag)).refined(this.minRefinedBucketSize, this.maxRefinedBucketSize)) {
                    if (intBucket.getCount() <= 0L) continue;
                    taskRefinedBuckets.add(new TEntry(tag, intBucket));
                }
            }
            List<List<TEntry>> taskIndexes = taskRefinedBuckets.divide(entry -> ((LongBucket)entry.getValue()).getCount(), threads);
            OutputConsumer<IRecord> writer = output.getWriters(taskIndexes.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < taskIndexes.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List taskRefinedBucket = (List)taskIndexes.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    CCFReader indexReader = new CCFReader((IReaderOption<?>)this.input);
                    BoxRecord indexRecord = indexReader.getRecord();
                    BoxRecord outputRecord = dataReader.getRecord();
                    LinkedObjectPool<BoxRecord> boxRecords = new LinkedObjectPool<BoxRecord>(() -> new BoxRecord(outputRecord.keys()));
                    LinkedObjectPool<Element> elements = new LinkedObjectPool<Element>(() -> {
                        Element element = new Element();
                        element.pointer = -1L;
                        element.record = null;
                        element.value = 0L;
                        return element;
                    });
                    List<Element> batchRecords = new List<Element>();
                    for (TEntry bucket : taskRefinedBucket) {
                        if (((LongBucket)bucket.getValue()).getCount() == 0L) continue;
                        dataReader.limit(((LongBucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        indexReader.limit(((LongBucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        if (((LongBucket)bucket.getValue()).isOrdered()) {
                            if (((LongBucket)bucket.getValue()).isCompact()) {
                                while (dataReader.read(outputRecord)) {
                                    writer.write(threadId, outputRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            } else {
                                TLongIterator pointers = ((LongBucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    dataReader.seek(pointers.next());
                                    dataReader.read(outputRecord);
                                    writer.write(threadId, outputRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            }
                        } else {
                            Element element;
                            int index;
                            elements.require((int)((LongBucket)bucket.getValue()).getCount());
                            if (((LongBucket)bucket.getValue()).isCompact()) {
                                index = 0;
                                while (indexReader.read(indexRecord)) {
                                    Element element2 = elements.get(index);
                                    element2.pointer = indexReader.tell() - 1L;
                                    element2.value = this.valueGetter.applyAsLong(indexRecord);
                                    ++index;
                                }
                            } else {
                                index = 0;
                                TLongIterator pointers = ((LongBucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    indexReader.seek(pointers.next());
                                    indexReader.read(indexRecord);
                                    element = elements.get(index);
                                    element.pointer = indexReader.tell() - 1L;
                                    element.value = this.valueGetter.applyAsLong(indexRecord);
                                    ++index;
                                }
                            }
                            elements.sort(Comparator.comparing(o -> o.value));
                            while (elements.size() > 0) {
                                int j;
                                int size = Math.min(this.bufferSize, elements.size());
                                boxRecords.require(size);
                                for (j = 0; j < size; ++j) {
                                    batchRecords.add(elements.popFirst());
                                }
                                batchRecords.sort(Comparator.comparingLong(o -> o.pointer));
                                for (j = 0; j < size; ++j) {
                                    element = (Element)batchRecords.get(j);
                                    dataReader.seek(element.pointer);
                                    BoxRecord record = boxRecords.popFirst();
                                    dataReader.read(record);
                                    element.record = record;
                                }
                                batchRecords.sort(Comparator.comparing(o -> o.value));
                                for (Element record : batchRecords) {
                                    writer.write(threadId, record.record);
                                    this.listener.sort(this.input, output, 1);
                                }
                                batchRecords.clear();
                                boxRecords.clear();
                            }
                            elements.clear();
                        }
                        ((LongBucket)bucket.getValue()).destroy();
                    }
                    batchRecords.close();
                    boxRecords.close();
                    elements.close();
                    dataReader.close();
                    indexReader.close();
                    taskRefinedBucket.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        public void memorySort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            List<MemoryObject> pointers = new List<MemoryObject>();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            LinkedSet tags = new LinkedSet();
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    List<MemoryObject<T>> objects = new List<MemoryObject<T>>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord boxRecord = reader.getRecord();
                        while (reader.read(boxRecord)) {
                            T tag = this.tagGetter.apply(boxRecord);
                            long value = this.valueGetter.applyAsLong(boxRecord);
                            objects.add(new MemoryObject<T>(tag, value, reader.tell() - 1L));
                            this.listener.crudeIndex(this.input, 1);
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (objects.size() != 0) {
                        List list = pointers;
                        synchronized (list) {
                            for (MemoryObject memoryObject : objects) {
                                pointers.add(memoryObject);
                                tags.add(memoryObject.tag);
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            Comparator comparator = (o1, o2) -> {
                int status = Integer.compare(tags.indexOf(o1.tag), tags.indexOf(o2.tag));
                if (status == 0 && (status = Long.compare(o1.value, o2.value)) == 0) {
                    status = Long.compare(o1.pointer, o2.pointer);
                }
                return status;
            };
            pointers.sort(comparator);
            List<List<MemoryObject>> tasks = pointers.divide(value -> 1L, threads);
            OutputConsumer<IRecord> writer = output.getWriters(tasks.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < tasks.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List objects = (List)tasks.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    BoxRecord record = dataReader.getRecord();
                    while (objects.size() > 0) {
                        dataReader.seek(((MemoryObject)objects.popFirst()).pointer);
                        dataReader.read(record);
                        writer.write(threadId, record);
                        this.listener.sort(this.input, output, 1);
                    }
                    dataReader.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        /* synthetic */ LongSorterSetting(IReaderOption x0, Function x1, ToLongFunction x2, 1 x3) {
            this(x0, x1, x2);
        }

        private static class MemoryObject<T> {
            final T tag;
            final long value;
            final long pointer;

            public MemoryObject(T tag, long value, long pointer) {
                this.tag = tag;
                this.value = value;
                this.pointer = pointer;
            }
        }

        private static class Element {
            BoxRecord record;
            long value;
            long pointer;

            private Element() {
            }
        }
    }

    public static class IntSorterSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final ToIntFunction<BoxRecord> valueGetter;
        ISortListener<I, OutputOption<IRecord, ?>> listener = ISortListener.EMPTY;
        int minRefinedBucketSize = 1024;
        int maxRefinedBucketSize = 0x200000;
        int bufferSize = 65536;
        TIntFunction projection = value -> value;

        private IntSorterSetting(I input, Function<BoxRecord, T> tagGetter, ToIntFunction<BoxRecord> valueGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.valueGetter = valueGetter;
        }

        public IntSorterSetting<I, T> setMinBucketSize(int size) {
            this.minRefinedBucketSize = ValueUtils.valueOf(size, 2, 0x10000000);
            return this;
        }

        public IntSorterSetting<I, T> setMaxBucketSize(int size) {
            this.maxRefinedBucketSize = ValueUtils.valueOf(size, 128, 0x10000000);
            return this;
        }

        public IntSorterSetting<I, T> setBufferSize(int size) {
            this.bufferSize = ValueUtils.valueOf(size, 64, 0x10000000);
            return this;
        }

        public IntSorterSetting<I, T> projectValue(TIntFunction projection) {
            this.projection = projection == null ? value -> value : projection;
            return this;
        }

        public IntSorterSetting<I, T> setListener(ISortListener<I, OutputOption<IRecord, ?>> listener) {
            this.listener = listener == null ? ISortListener.EMPTY : listener;
            return this;
        }

        public boolean isOrdered(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            LinkedHashMap crudeBuckets = new LinkedHashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            IntBucketFlusher flusher = (bucket, value, pointer) -> bucket.getCount() >= 4096L;
            AtomicBoolean ordered = new AtomicBoolean(true);
            this.listener.startCrudeIndex(this.input);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Iterator iterator2 = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap<T, DynamicCrudeIntBuckets> partialIndexer = new THashMap<T, DynamicCrudeIntBuckets>();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                int value = this.valueGetter.applyAsInt(record);
                                T lastTag = tag;
                                int lastValue = value;
                                DynamicCrudeIntBuckets lastBuckets = new DynamicCrudeIntBuckets(flusher);
                                partialIndexer.put(tag, lastBuckets);
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                if (ordered.get()) {
                                    for (Object tag : partialIndexer.keySet()) {
                                        if (!crudeBuckets.containsKey(tag)) {
                                            crudeBuckets.put(tag, new DynamicCrudeIntBuckets(flusher));
                                        }
                                        ((DynamicCrudeIntBuckets)crudeBuckets.get(tag)).update((DynamicCrudeIntBuckets)partialIndexer.get(tag));
                                    }
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                iterator2 = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (iterator2 != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)((Object)iterator2)).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stopCrudeIndex(this.input);
            if (ordered.get()) {
                LinkedHashMap indexer = new LinkedHashMap();
                for (Object tag : crudeBuckets.keySet()) {
                    indexer.put(tag, ((DynamicCrudeIntBuckets)crudeBuckets.get(tag)).refined());
                }
                for (RefinedIntBuckets buckets : indexer.values()) {
                    if (buckets.isOrdered() && buckets.isCompact()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void bucketSort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    THashMap<T, FixedCrudeIntBuckets> threadCrudeBucket = new THashMap<T, FixedCrudeIntBuckets>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord record = reader.getRecord();
                        if (reader.read(record)) {
                            T tag = this.tagGetter.apply(record);
                            int value = this.valueGetter.applyAsInt(record);
                            T lastTag = tag;
                            FixedCrudeIntBuckets lastBuckets = new FixedCrudeIntBuckets(this.projection);
                            threadCrudeBucket.put(tag, lastBuckets);
                            lastBuckets.update(value, reader.tell() - 1L);
                            this.listener.crudeIndex(this.input, 1);
                            while (reader.read(record)) {
                                tag = this.tagGetter.apply(record);
                                value = this.valueGetter.applyAsInt(record);
                                if (!Objects.equals(tag, lastTag)) {
                                    lastTag = tag;
                                    if (!threadCrudeBucket.containsKey(tag)) {
                                        lastBuckets = new FixedCrudeIntBuckets(this.projection);
                                        threadCrudeBucket.put(tag, lastBuckets);
                                    } else {
                                        lastBuckets = (FixedCrudeIntBuckets)threadCrudeBucket.get(tag);
                                    }
                                }
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                        }
                    }
                    catch (Throwable record) {
                        object = record;
                        throw record;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable record) {
                                    ((Throwable)object).addSuppressed(record);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (threadCrudeBucket.size() != 0) {
                        Map map = crudeBuckets;
                        synchronized (map) {
                            for (Object tag : threadCrudeBucket.keySet()) {
                                FixedCrudeIntBuckets bucket = (FixedCrudeIntBuckets)threadCrudeBucket.get(tag);
                                if (!crudeBuckets.containsKey(tag)) {
                                    crudeBuckets.put(tag, new FixedCrudeIntBuckets(this.projection));
                                }
                                ((FixedCrudeIntBuckets)crudeBuckets.get(tag)).update((FixedCrudeIntBuckets)threadCrudeBucket.get(tag));
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            List<TEntry> taskRefinedBuckets = new List<TEntry>();
            for (Object tag : crudeBuckets.keySet()) {
                for (IntBucket intBucket : ((FixedCrudeIntBuckets)crudeBuckets.get(tag)).refined(this.minRefinedBucketSize, this.maxRefinedBucketSize)) {
                    if (intBucket.getCount() <= 0L) continue;
                    taskRefinedBuckets.add(new TEntry(tag, intBucket));
                }
            }
            List<List<TEntry>> taskIndexes = taskRefinedBuckets.divide(entry -> ((IntBucket)entry.getValue()).getCount(), threads);
            OutputConsumer<IRecord> writer = output.getWriters(taskIndexes.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < taskIndexes.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List taskRefinedBucket = (List)taskIndexes.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    CCFReader indexReader = new CCFReader((IReaderOption<?>)this.input);
                    BoxRecord indexRecord = indexReader.getRecord();
                    BoxRecord outputRecord = dataReader.getRecord();
                    LinkedObjectPool<BoxRecord> boxRecords = new LinkedObjectPool<BoxRecord>(() -> new BoxRecord(outputRecord.keys()));
                    LinkedObjectPool<Element> elements = new LinkedObjectPool<Element>(() -> {
                        Element element = new Element();
                        element.pointer = -1L;
                        element.record = null;
                        element.value = 0;
                        return element;
                    });
                    List<Element> batchRecords = new List<Element>();
                    for (TEntry bucket : taskRefinedBucket) {
                        if (((IntBucket)bucket.getValue()).getCount() == 0L) continue;
                        dataReader.limit(((IntBucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        indexReader.limit(((IntBucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        if (((IntBucket)bucket.getValue()).isOrdered()) {
                            if (((IntBucket)bucket.getValue()).isCompact()) {
                                while (dataReader.read(outputRecord)) {
                                    writer.write(threadId, outputRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            } else {
                                TLongIterator pointers = ((IntBucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    dataReader.seek(pointers.next());
                                    dataReader.read(outputRecord);
                                    writer.write(threadId, outputRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            }
                        } else {
                            Element element;
                            int index;
                            elements.require((int)((IntBucket)bucket.getValue()).getCount());
                            if (((IntBucket)bucket.getValue()).isCompact()) {
                                index = 0;
                                while (indexReader.read(indexRecord)) {
                                    Element element2 = elements.get(index++);
                                    element2.pointer = indexReader.tell() - 1L;
                                    element2.value = this.valueGetter.applyAsInt(indexRecord);
                                }
                            } else {
                                index = 0;
                                TLongIterator pointers = ((IntBucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    indexReader.seek(pointers.next());
                                    indexReader.read(indexRecord);
                                    element = elements.get(index++);
                                    element.pointer = indexReader.tell() - 1L;
                                    element.value = this.valueGetter.applyAsInt(indexRecord);
                                }
                            }
                            elements.sort(Comparator.comparing(o -> o.value));
                            while (elements.size() > 0) {
                                int j;
                                int size = Math.min(this.bufferSize, elements.size());
                                boxRecords.require(size);
                                for (j = 0; j < size; ++j) {
                                    batchRecords.add(elements.popFirst());
                                }
                                batchRecords.sort(Comparator.comparingLong(o -> o.pointer));
                                for (j = 0; j < size; ++j) {
                                    element = (Element)batchRecords.get(j);
                                    dataReader.seek(element.pointer);
                                    BoxRecord record = boxRecords.popFirst();
                                    dataReader.read(record);
                                    element.record = record;
                                }
                                batchRecords.sort(Comparator.comparing(o -> o.value));
                                for (Element record : batchRecords) {
                                    writer.write(threadId, record.record);
                                    this.listener.sort(this.input, output, 1);
                                }
                                batchRecords.clear();
                                boxRecords.clear();
                            }
                            elements.clear();
                        }
                        ((IntBucket)bucket.getValue()).destroy();
                    }
                    batchRecords.close();
                    boxRecords.close();
                    elements.close();
                    dataReader.close();
                    indexReader.close();
                    taskRefinedBucket.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        public void memorySort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            List<MemoryObject> pointers = new List<MemoryObject>();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            LinkedSet tags = new LinkedSet();
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    List<MemoryObject<T>> objects = new List<MemoryObject<T>>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord boxRecord = reader.getRecord();
                        while (reader.read(boxRecord)) {
                            T tag = this.tagGetter.apply(boxRecord);
                            int value = this.valueGetter.applyAsInt(boxRecord);
                            objects.add(new MemoryObject<T>(tag, value, reader.tell() - 1L));
                            this.listener.crudeIndex(this.input, 1);
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (objects.size() != 0) {
                        List list = pointers;
                        synchronized (list) {
                            for (MemoryObject memoryObject : objects) {
                                pointers.add(memoryObject);
                                tags.add(memoryObject.tag);
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            Comparator comparator = (o1, o2) -> {
                int status = Integer.compare(tags.indexOf(o1.tag), tags.indexOf(o2.tag));
                if (status == 0 && (status = Integer.compare(o1.value, o2.value)) == 0) {
                    status = Long.compare(o1.pointer, o2.pointer);
                }
                return status;
            };
            pointers.sort(comparator);
            List<List<MemoryObject>> tasks = pointers.divide(value -> 1L, threads);
            OutputConsumer<IRecord> writer = output.getWriters(tasks.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < tasks.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List objects = (List)tasks.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    BoxRecord record = dataReader.getRecord();
                    while (objects.size() > 0) {
                        dataReader.seek(((MemoryObject)objects.popFirst()).pointer);
                        dataReader.read(record);
                        writer.write(threadId, record);
                        this.listener.sort(this.input, output, 1);
                    }
                    dataReader.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        /* synthetic */ IntSorterSetting(IReaderOption x0, Function x1, ToIntFunction x2, 1 x3) {
            this(x0, x1, x2);
        }

        private static class Element {
            BoxRecord record;
            int value;
            long pointer;

            private Element() {
            }
        }

        private static class MemoryObject<T> {
            final T tag;
            final int value;
            final long pointer;

            public MemoryObject(T tag, int value, long pointer) {
                this.tag = tag;
                this.value = value;
                this.pointer = pointer;
            }
        }
    }

    public static class SorterSetting<I extends IReaderOption<I>, T, V extends Comparable<V>> {
        final I input;
        final Function<BoxRecord, T> tagGetter;
        final Function<BoxRecord, V> valueGetter;
        ISortListener<I, OutputOption<IRecord, ?>> listener = ISortListener.EMPTY;
        int minRefinedBucketSize = 1024;
        int maxRefinedBucketSize = 0x200000;
        int bufferSize = 65536;
        ToIntFunction<V> projection = value -> 0;

        private SorterSetting(I input, Function<BoxRecord, T> tagGetter, Function<BoxRecord, V> valueGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
            this.valueGetter = valueGetter;
        }

        public SorterSetting<I, T, V> setMinBucketSize(int size) {
            this.minRefinedBucketSize = ValueUtils.valueOf(size, 2, 0x10000000);
            return this;
        }

        public SorterSetting<I, T, V> setMaxBucketSize(int size) {
            this.maxRefinedBucketSize = ValueUtils.valueOf(size, 128, 0x10000000);
            return this;
        }

        public SorterSetting<I, T, V> setBufferSize(int size) {
            this.bufferSize = ValueUtils.valueOf(size, 64, 0x10000000);
            return this;
        }

        public SorterSetting<I, T, V> projectValue(ToIntFunction<V> projection) {
            this.projection = projection == null ? value -> 0 : projection;
            return this;
        }

        public SorterSetting<I, T, V> setListener(ISortListener<I, OutputOption<IRecord, ?>> listener) {
            this.listener = listener == null ? ISortListener.EMPTY : listener;
            return this;
        }

        public boolean isOrdered(int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            LinkedHashMap crudeBuckets = new LinkedHashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            BucketFlusher<Comparable> flusher = (bucket, value, pointer) -> bucket.getCount() >= 4096L;
            AtomicBoolean ordered = new AtomicBoolean(true);
            this.listener.startCrudeIndex(this.input);
            ThreadQueue pool = new ThreadQueue(readers.size());
            Iterator iterator2 = null;
            try {
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    pool.addTask((status, context) -> {
                        THashMap partialIndexer = new THashMap();
                        try (CCFReader reader = (CCFReader)readers.get(threadId);){
                            BoxRecord record = reader.getRecord();
                            if (reader.read(record)) {
                                T tag = this.tagGetter.apply(record);
                                Comparable value = (Comparable)this.valueGetter.apply(record);
                                T lastTag = tag;
                                Comparable lastValue = value;
                                DynamicCrudeBuckets<Comparable> lastBuckets = new DynamicCrudeBuckets<Comparable>(flusher);
                                partialIndexer.put(tag, lastBuckets);
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                            Map map = crudeBuckets;
                            synchronized (map) {
                                if (ordered.get()) {
                                    for (Object tag : partialIndexer.keySet()) {
                                        if (!crudeBuckets.containsKey(tag)) {
                                            crudeBuckets.put(tag, new DynamicCrudeBuckets(flusher));
                                        }
                                        ((DynamicCrudeBuckets)crudeBuckets.get(tag)).update((DynamicCrudeBuckets)partialIndexer.get(tag));
                                    }
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable i) {
                iterator2 = i;
                throw i;
            }
            finally {
                if (pool != null) {
                    if (iterator2 != null) {
                        try {
                            pool.close();
                        }
                        catch (Throwable i) {
                            ((Throwable)((Object)iterator2)).addSuppressed(i);
                        }
                    } else {
                        pool.close();
                    }
                }
            }
            this.listener.stopCrudeIndex(this.input);
            if (ordered.get()) {
                LinkedHashMap indexer = new LinkedHashMap();
                for (Object tag : crudeBuckets.keySet()) {
                    indexer.put(tag, ((DynamicCrudeBuckets)crudeBuckets.get(tag)).refined());
                }
                for (RefinedBuckets buckets : indexer.values()) {
                    if (buckets.isOrdered() && buckets.isCompact()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void bucketSort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            THashMap crudeBuckets = new THashMap();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    THashMap<T, FixedCrudeBuckets<V>> threadCrudeBucket = new THashMap<T, FixedCrudeBuckets<V>>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord record = reader.getRecord();
                        if (reader.read(record)) {
                            T tag = this.tagGetter.apply(record);
                            Comparable value = (Comparable)this.valueGetter.apply(record);
                            T lastTag = tag;
                            FixedCrudeBuckets<Comparable> lastBuckets = new FixedCrudeBuckets<Comparable>(this.projection);
                            threadCrudeBucket.put(tag, lastBuckets);
                            lastBuckets.update(value, reader.tell() - 1L);
                            this.listener.crudeIndex(this.input, 1);
                            while (reader.read(record)) {
                                tag = this.tagGetter.apply(record);
                                value = (Comparable)this.valueGetter.apply(record);
                                if (!Objects.equals(tag, lastTag)) {
                                    lastTag = tag;
                                    if (!threadCrudeBucket.containsKey(tag)) {
                                        lastBuckets = new FixedCrudeBuckets<Comparable>(this.projection);
                                        threadCrudeBucket.put(tag, lastBuckets);
                                    } else {
                                        lastBuckets = (FixedCrudeBuckets<Comparable>)threadCrudeBucket.get(tag);
                                    }
                                }
                                lastBuckets.update(value, reader.tell() - 1L);
                                this.listener.crudeIndex(this.input, 1);
                            }
                        }
                    }
                    catch (Throwable record) {
                        object = record;
                        throw record;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable record) {
                                    ((Throwable)object).addSuppressed(record);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (threadCrudeBucket.size() != 0) {
                        Map map = crudeBuckets;
                        synchronized (map) {
                            for (Object tag : threadCrudeBucket.keySet()) {
                                FixedCrudeBuckets bucket = (FixedCrudeBuckets)threadCrudeBucket.get(tag);
                                if (!crudeBuckets.containsKey(tag)) {
                                    crudeBuckets.put(tag, new FixedCrudeBuckets<V>(this.projection));
                                }
                                ((FixedCrudeBuckets)crudeBuckets.get(tag)).update((FixedCrudeBuckets)threadCrudeBucket.get(tag));
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            List<TEntry> taskRefinedBuckets = new List<TEntry>();
            for (Object tag : crudeBuckets.keySet()) {
                for (Bucket intBucket : ((FixedCrudeBuckets)crudeBuckets.get(tag)).refined(this.minRefinedBucketSize, this.maxRefinedBucketSize)) {
                    if (intBucket.getCount() <= 0L) continue;
                    taskRefinedBuckets.add(new TEntry(tag, intBucket));
                }
            }
            List<List<TEntry>> taskIndexes = taskRefinedBuckets.divide(entry -> ((Bucket)entry.getValue()).getCount(), threads);
            OutputConsumer<IRecord> writer = output.getWriters(taskIndexes.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < taskIndexes.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List taskRefinedBucket = (List)taskIndexes.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    CCFReader indexReader = new CCFReader((IReaderOption<?>)this.input);
                    BoxRecord indexRecord = indexReader.getRecord();
                    BoxRecord dataRecord = dataReader.getRecord();
                    LinkedObjectPool<BoxRecord> boxRecords = new LinkedObjectPool<BoxRecord>(() -> new BoxRecord(dataRecord.keys()));
                    LinkedObjectPool<Element> elements = new LinkedObjectPool<Element>(() -> {
                        Element element = new Element();
                        element.pointer = -1L;
                        element.record = null;
                        element.value = null;
                        return element;
                    });
                    List<Element> batchRecords = new List<Element>();
                    for (TEntry bucket : taskRefinedBucket) {
                        if (((Bucket)bucket.getValue()).getCount() == 0L) continue;
                        dataReader.limit(((Bucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        indexReader.limit(((Bucket)bucket.getValue()).getRecordIndexRange()).seek(0L);
                        if (((Bucket)bucket.getValue()).isOrdered()) {
                            if (((Bucket)bucket.getValue()).isCompact()) {
                                while (dataReader.read(dataRecord)) {
                                    writer.write(threadId, dataRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            } else {
                                TLongIterator pointers = ((Bucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    dataReader.seek(pointers.next());
                                    dataReader.read(dataRecord);
                                    writer.write(threadId, dataRecord);
                                    this.listener.sort(this.input, output, 1);
                                }
                            }
                        } else {
                            Element element;
                            int index;
                            elements.require((int)((Bucket)bucket.getValue()).getCount());
                            if (((Bucket)bucket.getValue()).isCompact()) {
                                index = 0;
                                while (indexReader.read(indexRecord)) {
                                    Element element2 = elements.get(index);
                                    element2.pointer = indexReader.tell() - 1L;
                                    element2.value = (Comparable)this.valueGetter.apply(indexRecord);
                                    ++index;
                                }
                            } else {
                                index = 0;
                                TLongIterator pointers = ((Bucket)bucket.getValue()).iterator();
                                while (pointers.hasNext()) {
                                    indexReader.seek(pointers.next());
                                    indexReader.read(indexRecord);
                                    element = elements.get(index);
                                    element.pointer = indexReader.tell() - 1L;
                                    element.value = (Comparable)this.valueGetter.apply(indexRecord);
                                    ++index;
                                }
                            }
                            elements.sort(Comparator.comparing(o -> o.value));
                            while (elements.size() > 0) {
                                int j;
                                int size = Math.min(this.bufferSize, elements.size());
                                boxRecords.require(size);
                                for (j = 0; j < size; ++j) {
                                    batchRecords.add(elements.popFirst());
                                }
                                batchRecords.sort(Comparator.comparingLong(o -> o.pointer));
                                for (j = 0; j < size; ++j) {
                                    element = (Element)batchRecords.get(j);
                                    dataReader.seek(element.pointer);
                                    BoxRecord record = boxRecords.popFirst();
                                    dataReader.read(record);
                                    element.record = record;
                                }
                                batchRecords.sort(Comparator.comparing(o -> o.value));
                                for (Element record : batchRecords) {
                                    writer.write(threadId, record.record);
                                    this.listener.sort(this.input, output, 1);
                                }
                                batchRecords.clear();
                                boxRecords.clear();
                            }
                            elements.clear();
                        }
                        ((Bucket)bucket.getValue()).destroy();
                    }
                    batchRecords.close();
                    boxRecords.close();
                    elements.close();
                    dataReader.close();
                    indexReader.close();
                    taskRefinedBucket.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        public void memorySort(OutputOption<IRecord, ?> output, int threads) throws IOException {
            threads = RuntimeProperty.verifyThreads(threads);
            List<MemoryObject> pointers = new List<MemoryObject>();
            List<CCFReader> readers = new CCFReader((IReaderOption<?>)this.input).part(threads);
            ThreadQueue queue = new ThreadQueue(threads);
            LinkedSet tags = new LinkedSet();
            this.listener.startCrudeIndex(this.input);
            int i = 0;
            while (i < readers.size()) {
                int threadId = i++;
                queue.addTask((status, context) -> {
                    List<MemoryObject<T, Comparable>> objects = new List<MemoryObject<T, Comparable>>();
                    CCFReader reader = (CCFReader)readers.get(threadId);
                    Object object = null;
                    try {
                        BoxRecord boxRecord = reader.getRecord();
                        while (reader.read(boxRecord)) {
                            T tag = this.tagGetter.apply(boxRecord);
                            Comparable value = (Comparable)this.valueGetter.apply(boxRecord);
                            objects.add(new MemoryObject<T, Comparable>(tag, value, reader.tell() - 1L));
                            this.listener.crudeIndex(this.input, 1);
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                    if (objects.size() != 0) {
                        List list = pointers;
                        synchronized (list) {
                            for (MemoryObject memoryObject : objects) {
                                pointers.add(memoryObject);
                                tags.add(memoryObject.tag);
                            }
                        }
                    }
                });
            }
            queue.await();
            this.listener.stopCrudeIndex(this.input);
            Comparator comparator = (o1, o2) -> {
                int status = Integer.compare(tags.indexOf(o1.tag), tags.indexOf(o2.tag));
                if (status == 0 && (status = ((Comparable)o1.value).compareTo(o2.value)) == 0) {
                    status = Long.compare(o1.pointer, o2.pointer);
                }
                return status;
            };
            pointers.sort(comparator);
            List<List<MemoryObject>> tasks = pointers.divide(value -> 1L, threads);
            OutputConsumer<IRecord> writer = output.getWriters(tasks.size());
            this.listener.startSort(this.input, output);
            int i2 = 0;
            while (i2 < tasks.size()) {
                int threadId = i2++;
                queue.addTask((status, context) -> {
                    List objects = (List)tasks.get(threadId);
                    CCFReader dataReader = new CCFReader(((IReaderOption)this.input).getTable());
                    BoxRecord record = dataReader.getRecord();
                    while (objects.size() > 0) {
                        dataReader.seek(((MemoryObject)objects.popFirst()).pointer);
                        dataReader.read(record);
                        writer.write(threadId, record);
                        this.listener.sort(this.input, output, 1);
                    }
                    dataReader.close();
                    writer.finish(threadId);
                });
            }
            queue.close();
            writer.close();
            this.listener.stopSort(this.input, output);
        }

        /* synthetic */ SorterSetting(IReaderOption x0, Function x1, Function x2, 1 x3) {
            this(x0, x1, x2);
        }

        private static class MemoryObject<T, V> {
            final T tag;
            final V value;
            final long pointer;

            public MemoryObject(T tag, V value, long pointer) {
                this.tag = tag;
                this.value = value;
                this.pointer = pointer;
            }
        }

        private static class Element<V extends Comparable<V>> {
            BoxRecord record;
            V value;
            long pointer;

            private Element() {
            }
        }
    }

    public static class TagSetting<I extends IReaderOption<I>, T> {
        final I input;
        final Function<BoxRecord, T> tagGetter;

        private TagSetting(I input, Function<BoxRecord, T> tagGetter) {
            this.input = input;
            this.tagGetter = tagGetter;
        }

        public <V extends Comparable<V>> SorterSetting<I, T, V> getValueFrom(Function<BoxRecord, V> valueGetter) {
            return new SorterSetting((IReaderOption)this.input, this.tagGetter, valueGetter, null);
        }

        public IntSorterSetting<I, T> getIntValueFrom(ToIntFunction<BoxRecord> valueGetter) {
            return new IntSorterSetting((IReaderOption)this.input, this.tagGetter, valueGetter, null);
        }

        public LongSorterSetting<I, T> getLongValueFrom(ToLongFunction<BoxRecord> valueGetter) {
            return new LongSorterSetting((IReaderOption)this.input, this.tagGetter, valueGetter, null);
        }

        /* synthetic */ TagSetting(IReaderOption x0, Function x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class InputSetting<I extends IReaderOption<I>> {
        final I input;

        private InputSetting(I input) {
            this.input = input;
        }

        public <T> TagSetting<I, T> getTagFrom(Function<BoxRecord, T> tagGetter) {
            return new TagSetting((IReaderOption)this.input, tagGetter, null);
        }

        /* synthetic */ InputSetting(IReaderOption x0, 1 x1) {
            this(x0);
        }
    }
}

