/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseBatch;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.ccf.toolkit.listener.IAnnotationListener;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Annotator {
    final List<DatabaseBatch<BoxRecord>> batches = new List();
    final IReaderOption<?> input;
    final File output;
    final ICCFMeta meta = new CCFMeta();
    final ICCFOptions options = new CCFOptions();
    IAnnotationListener<BoxRecord> listener = IAnnotationListener.EMPTY;

    private Annotator(IReaderOption<?> reference, File output) {
        this.input = reference;
        this.output = output;
    }

    public static InputSetting setInput(String input) throws IOException {
        return new InputSetting((IReaderOption)new ReaderOption(input, new String[0]).addAllFields());
    }

    public static InputSetting setInput(File input) throws IOException {
        return new InputSetting((IReaderOption)new ReaderOption(input, new String[0]).addAllFields());
    }

    public static InputSetting setInput(LiveFile input) throws IOException {
        return new InputSetting((IReaderOption)new ReaderOption(input, new String[0]).addAllFields());
    }

    public static InputSetting setInput(CCFTable input) throws IOException {
        return new InputSetting((IReaderOption)new ReaderOption(input, new String[0]).addAllFields());
    }

    public static InputSetting setInput(IReaderOption<?> input) {
        return new InputSetting(input);
    }

    public Annotator addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public Annotator addMeta(Iterable<CCFMetaItem> metas) {
        this.meta.adds(metas);
        return this;
    }

    public Annotator clearOptions() {
        this.options.clear();
        return this;
    }

    public Annotator addOption(CCFMetaItem option) {
        this.options.add(option);
        return this;
    }

    public Annotator addOptions(Iterable<CCFMetaItem> options) {
        this.options.adds(options);
        return this;
    }

    public Annotator clearMeta() {
        this.meta.clear();
        return this;
    }

    public Annotator dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public Annotator setListener(IAnnotationListener<BoxRecord> listener) {
        this.listener = listener == null ? IAnnotationListener.EMPTY : listener;
        return this;
    }

    public void append(int threads) throws IOException {
        this.listener.start(this.batches, this.output);
        threads = RuntimeProperty.verifyThreads(threads);
        ICCFMeta meta = new CCFMeta().adds(this.meta);
        THashSet<String> groups2 = new THashSet<String>();
        ThreadQueue queue = new ThreadQueue(threads);
        List<CCFReader> readers = new CCFReader(this.input).part(threads);
        ChannelWriterStream writer = new ChannelWriterStream(this.output);
        int groupIndex = this.mergeFieldData(groups2, 0, this.input.getTable(), writer);
        for (DatabaseBatch<BoxRecord> batch : this.batches) {
            meta.adds(batch.getMeta());
            this.listener.startBatch(batch, this.output);
            if (batch.numOfFields() > 0 && batch.numOfDatabases() > 0) {
                CCFWriter writers = CCFWriter.setOutput(RuntimeProperty.createTempFile()).addFields(batch.getAllFields()).instance(threads);
                IFieldCollection fields = ((FieldGroupMetas)((FieldGroupMetas)new FieldGroupMetas().addFields((Iterable)this.input.getAllFields())).addFields((Iterable)batch.getAllFields())).asUnmodifiable();
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    queue.addTask((status, context) -> {
                        CCFReader reader = (CCFReader)readers.get(threadId);
                        reader.seek(0L);
                        BoxRecord record = new BoxRecord(fields);
                        List databases = new List();
                        for (Database database : batch.getAllDatabases()) {
                            databases.add(database.instance());
                        }
                        while (reader.read(record)) {
                            this.listener.stepBatch(batch, this.output, 1L, 0L);
                            long pointer = reader.tell() - 1L;
                            for (Database.Reader database : databases) {
                                database.annotate(pointer, record);
                            }
                            writers.write(threadId, record);
                            this.listener.stepBatch(batch, this.output, 0L, 1L);
                        }
                        writers.finish(threadId);
                        for (Database.Reader reader2 : databases) {
                            reader2.close();
                        }
                    });
                }
                queue.await();
                writers.close();
                groupIndex = this.mergeFieldData(groups2, groupIndex, new CCFTable(writers.getFile()), writer);
                FileUtils.delete(writers.getFile());
            }
            this.listener.stopBatch(batch, this.output, this.input.numOfRecords(), this.input.numOfRecords());
        }
        queue.close();
        for (CCFReader reader : readers) {
            reader.close();
        }
        MetaCodec.saveTo(meta, writer);
        OptionCodec.saveTo(this.options, (IWriterStream)writer);
        writer.close();
        this.listener.stop(this.batches, this.output);
    }

    public void submit(int threads) throws IOException {
        this.listener.start(this.batches, this.output);
        threads = RuntimeProperty.verifyThreads(threads);
        IReaderOption<Object> input = this.input;
        ICCFMeta meta = new CCFMeta().adds(this.meta);
        ThreadQueue queue = new ThreadQueue(threads);
        FieldGroupMetas fields = new FieldGroupMetas(this.input.getAllFields());
        for (DatabaseBatch<BoxRecord> batch : this.batches) {
            meta.adds(batch.getMeta());
            this.listener.startBatch(batch, this.output);
            AtomicLong batchReads = new AtomicLong();
            AtomicLong batchWrites = new AtomicLong();
            if (batch.numOfDatabases() > 0) {
                List<CCFReader> readers = new CCFReader(input).part(threads);
                fields.addFields((Iterable)batch.getAllFields());
                CCFWriter writers = CCFWriter.setOutput(this.output).addFields(fields).instance(threads);
                int i = 0;
                while (i < readers.size()) {
                    int threadId = i++;
                    queue.addTask((status, context) -> {
                        long read = 0L;
                        long write = 0L;
                        CCFReader reader = (CCFReader)readers.get(threadId);
                        BoxRecord record = writers.getRecord();
                        List databases = new List();
                        for (Database database : batch.getAllDatabases()) {
                            databases.add(database.instance());
                        }
                        while (reader.read(record)) {
                            ++read;
                            this.listener.stepBatch(batch, this.output, 1L, 0L);
                            long pointer = reader.tell() - 1L;
                            boolean accept = true;
                            for (Database.Reader database : databases) {
                                if (database.annotate(pointer, record)) continue;
                                accept = false;
                                break;
                            }
                            if (!accept) continue;
                            writers.write(threadId, record);
                            ++write;
                            this.listener.stepBatch(batch, this.output, 0L, 1L);
                        }
                        writers.finish(threadId);
                        for (Database.Reader reader2 : databases) {
                            reader2.close();
                        }
                        reader.close();
                        batchReads.addAndGet(read);
                        batchWrites.addAndGet(write);
                    });
                }
                queue.await();
                readers.close();
                writers.close();
                input = new ReaderOption(this.output, new String[0]).addAllFields();
            }
            this.listener.stopBatch(batch, this.output, batchReads.get(), batchWrites.get());
        }
        queue.close();
        if (meta.size() > 0 || this.options.size() > 0) {
            ChannelAppendStream appender = new ChannelAppendStream(this.output);
            MetaCodec.saveTo(meta, appender);
            OptionCodec.saveTo(this.options, (IWriterStream)appender);
            appender.close();
        }
        this.listener.stop(this.batches, this.output);
    }

    private int mergeFieldData(Set<String> groups2, int groupIndex, CCFTable table, ChannelWriterStream output) throws IOException {
        IFieldCollection fields = table.getAllFields();
        for (String string : fields.getAllFieldGroupNames()) {
            if (groups2.contains(string)) {
                throw new DatabaseException("Duplicated field group: " + fields.getFieldGroup(string));
            }
            groups2.add(string);
        }
        if (table.numOfRecords() > 0L) {
            ISeekableReaderStream reader = table.getFile().openAsBinary();
            for (String groupName : fields.getAllFieldGroupNames()) {
                FieldGroupMetaCodec.saveTo(groupIndex, table.getFieldGroup(groupName), output);
                CCFHeaders blocks = table.getFieldGroupBlocks(groupName);
                ByteStream temp = ByteStream.getThreadInstance();
                temp.putVarInt32(groupIndex);
                temp.putVarInt32(0);
                temp.putVarInt32(blocks.numOfBlocks());
                long length = 0L;
                for (CCFHeader block : blocks) {
                    temp.putVarInt32(block.numOfRecords());
                    temp.putVarInt32(block.length());
                    length += (long)block.length();
                }
                output.write(FieldGroupDataCodec.getType().ordinal());
                output.writeLong((long)temp.length() + length, 8);
                output.write(temp.bytes(), temp.offset(), temp.length());
                for (CCFHeader block : blocks) {
                    int byteToWrite;
                    reader.seek(block.tell());
                    for (int count = block.length(); count > 0; count -= byteToWrite) {
                        byteToWrite = reader.read(temp.bytes(), 0, Math.min(temp.capacity(), count));
                        output.write(temp.bytes(), 0, byteToWrite);
                    }
                }
                ++groupIndex;
            }
            reader.close();
        } else {
            for (String string : fields.getAllFieldGroupNames()) {
                FieldGroupMetaCodec.saveTo(groupIndex++, table.getFieldGroup(string), output);
            }
        }
        return groupIndex;
    }

    public Annotator addDatabase(Database<?, BoxRecord> database) {
        if (database != null) {
            this.batches.add(DatabaseBatch.add(database).build());
        }
        return this;
    }

    public Annotator addDatabases(Iterable<Database<?, BoxRecord>> databases) {
        if (databases != null) {
            this.batches.add(DatabaseBatch.add(databases).build());
        }
        return this;
    }

    public Annotator addDatabases(DatabaseBatch<BoxRecord> database) {
        if (database != null) {
            this.batches.add(database);
        }
        return this;
    }

    public static class InputSetting {
        final List<DatabaseBatch<BoxRecord>> batches = new List();
        final IReaderOption<?> reference;

        private InputSetting(IReaderOption<?> reference) {
            this.reference = reference;
        }

        public Annotator setOutput(File output) {
            return new Annotator(this.reference, output);
        }

        public Annotator setOutput(String output) {
            return new Annotator(this.reference, new File(output));
        }
    }
}

