/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.list.List;
import java.io.Closeable;
import java.io.IOException;

public abstract class Database<D, I>
implements IFieldCollection {
    @Override
    public IFieldCollection getAllFields() {
        return IFieldCollection.EMPTY;
    }

    @Override
    public final int numOfFields() {
        return this.getAllFields().numOfFields();
    }

    public ICCFMeta getMeta() {
        return ICCFMeta.EMPTY;
    }

    public boolean contains(I target) {
        return true;
    }

    public boolean annotate(List<D> resources, long pointer, I target) {
        return true;
    }

    public <T extends Reader<D, I, Database<D, I>>> T instance() throws IOException {
        return (T)new Reader<D, I, Database<D, I>>(this){

            @Override
            public List<D> find(long pointer, I target) {
                return List.EMPTY();
            }

            @Override
            public boolean annotate(long pointer, I target) {
                return Database.this.annotate(this.find(pointer, target), pointer, target);
            }
        };
    }

    public String getDatabaseName() {
        return this.getClass().getName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.numOfFields() > 0) {
            builder.append(this.getDatabaseName());
            builder.append(": ");
            List<String> links = new List<String>();
            for (FieldMeta field : this.getAllFields()) {
                links.add(field.fullName() + " (" + field.type() + ")");
            }
            builder.append(links.toString(", "));
        }
        return builder.toString();
    }

    public static abstract class Reader<D, I, T extends Database<D, I>>
    implements AutoCloseable,
    Closeable {
        protected final T database;

        public Reader(T database) {
            this.database = database;
        }

        public List<D> find(long pointer, I target) throws IOException {
            return List.EMPTY();
        }

        public boolean annotate(long pointer, I target) throws IOException {
            List<Object> finds = this.find(pointer, target);
            if (finds == null) {
                finds = List.EMPTY();
            }
            return ((Database)this.database).annotate(finds, pointer, target);
        }

        public void reset() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public final Database<D, I> getDatabase() {
            return this.database;
        }
    }
}

