/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.list.List;

public class DatabaseBatch<I> {
    final List<Database<?, I>> databases = new List();
    final ICCFMeta meta;
    final IFieldCollection fields;

    public DatabaseBatch(List<Database<?, I>> inputs) {
        CCFMeta meta = new CCFMeta();
        FieldGroupMetas fields = new FieldGroupMetas();
        for (Database<?, I> database : inputs) {
            meta.adds(database.getMeta());
            fields.addFields((Iterable)database.getAllFields());
            this.databases.add(database);
        }
        this.meta = meta.asUnmodifiable();
        this.fields = fields.asUnmodifiable();
    }

    public static <I> InputSetting<I> init(Class<I> tClass) {
        return new InputSetting(List.EMPTY());
    }

    public static <I> InputSetting<I> add(Database<?, I> input) {
        return new InputSetting(List.singleton(input));
    }

    public static <I> InputSetting<I> add(Database<?, I>[] inputs) {
        return new InputSetting(List.wrap(inputs));
    }

    public static <I> InputSetting<I> add(Iterable<Database<?, I>> inputs) {
        return new InputSetting(inputs);
    }

    public IFieldCollection getAllFields() {
        return this.fields;
    }

    public List<Database<?, I>> getAllDatabases() {
        return this.databases.asUnmodifiable();
    }

    public int numOfDatabases() {
        return this.databases.size();
    }

    public int numOfFields() {
        return this.fields.numOfFields();
    }

    public ICCFMeta getMeta() {
        return this.meta;
    }

    public static class InputSetting<I> {
        final List<Database<?, I>> inputs = new List();

        private InputSetting(Iterable<Database<?, I>> inputs) {
            if (inputs != null) {
                for (Database<?, I> input : inputs) {
                    if (input == null) continue;
                    this.inputs.add(input);
                }
            }
        }

        public InputSetting<I> add(Database<?, I> input) {
            if (input != null) {
                this.inputs.add(input);
            }
            return this;
        }

        public InputSetting<I> add(Database<?, I>[] inputs) {
            if (inputs != null) {
                for (Database<?, I> input : inputs) {
                    if (input == null) continue;
                    this.inputs.add(input);
                }
            }
            return this;
        }

        public InputSetting<I> add(Iterable<? extends Database<?, I>> inputs) {
            if (inputs != null) {
                for (Database<?, I> input : inputs) {
                    if (input == null) continue;
                    this.inputs.add(input);
                }
            }
            return this;
        }

        public DatabaseBatch<I> build() {
            return new DatabaseBatch<I>(this.inputs);
        }

        public int numOfDatabases() {
            return this.inputs.size();
        }
    }
}

