/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.filter.GTBFilter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class GTBDatabase
extends Database<Variant, Variant> {
    protected final GTBReaderOption option;
    protected final IFieldCollection fields;
    protected final ICCFMeta meta;

    public GTBDatabase(String file) throws IOException {
        this(new GTBReaderOption(file, false, true));
    }

    public GTBDatabase(File file) throws IOException {
        this(new GTBReaderOption(file, false, true));
    }

    public GTBDatabase(LiveFile file) throws IOException {
        this(new GTBReaderOption(file, false, true));
    }

    public GTBDatabase(CCFTable file) throws IOException {
        this(new GTBReaderOption(file, false, true));
    }

    public GTBDatabase(GTBManager file) throws IOException {
        this(new GTBReaderOption(file, false, true));
    }

    public GTBDatabase(GTBReaderOption option) {
        this.option = option;
        this.fields = this.option.getAllSupplementaryFields();
        this.meta = this.option.getTable().getMeta();
    }

    public GTBDatabase(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        this.option = option;
        this.fields = fields == null ? this.option.getAllSupplementaryFields() : fields.asUnmodifiable();
        this.meta = meta == null ? this.option.getTable().getMeta() : meta.asUnmodifiable();
    }

    @Override
    public final IFieldCollection getAllFields() {
        return this.fields;
    }

    @Override
    public final ICCFMeta getMeta() {
        return this.meta;
    }

    @Override
    public boolean contains(Variant target) {
        return target.numOfAlleles() == 2 && Variant.isStandardAllele(target.alleleOfIndex(0)) && Variant.isStandardAllele(target.alleleOfIndex(1));
    }

    @Override
    public boolean annotate(List<Variant> sources, long pointer, Variant variant) {
        if (sources != null && sources.size() > 0 && this.contains(variant)) {
            block0: for (Variant resource : sources) {
                if (variant.numOfAlleles() != resource.numOfAlleles()) continue;
                for (int alleleIndex = 0; alleleIndex < variant.numOfAlleles(); ++alleleIndex) {
                    if (!variant.alleleOfIndex(alleleIndex).equals(resource.alleleOfIndex(alleleIndex))) continue block0;
                }
                for (FieldMeta field : this.getAllFields()) {
                    variant.setProperty(field.fullName(), resource.getProperty(field.fullName()));
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public Reader instance() throws IOException {
        return new Reader(this);
    }

    @Override
    public String getDatabaseName() {
        return this.option.getFile().getPath();
    }

    public GTBReaderOption getReaderOption() {
        return this.option;
    }

    public static class Reader
    extends Database.Reader<Variant, Variant, Database<Variant, Variant>> {
        final GTBReader reader;
        final GTBFilter filter;
        final Set<Chromosome> chromosomes = new THashSet<Chromosome>();
        List<Variant> variants = List.EMPTY();

        public Reader(GTBDatabase database) throws IOException {
            super(database);
            this.reader = new GTBReader(database.option);
            this.filter = new GTBFilter(database.option.getGTBManager());
        }

        public Reader(Database<Variant, Variant> database, GTBReaderOption option) throws IOException {
            super(database);
            this.reader = new GTBReader(option);
            this.filter = new GTBFilter(option.getGTBManager());
        }

        @Override
        public List<Variant> find(long pointer, Variant target) throws IOException {
            boolean find;
            if (!this.database.contains(target)) {
                return List.EMPTY();
            }
            if (this.variants.size() > 0 && target.getCoordinate().equals(this.variants.fastGet(0).getCoordinate())) {
                return this.variants;
            }
            if (!this.chromosomes.contains(target.getChromosome())) {
                this.filter.seek(0L);
                this.chromosomes.add(target.getChromosome());
            }
            if (find = this.filter.find(target.getChromosome(), target.getPosition())) {
                this.reader.seek(this.filter.tell());
                return this.reader.reads();
            }
            return List.EMPTY();
        }

        @Override
        public boolean annotate(long pointer, Variant target) throws IOException {
            return this.database.annotate(this.find(pointer, target), pointer, target);
        }

        @Override
        public void reset() throws IOException {
            this.reader.seek(0L);
            this.filter.reset();
            this.filter.seek(0L);
            this.variants = null;
            this.chromosomes.clear();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.filter.reset();
            this.filter.close();
            this.variants = null;
            this.chromosomes.clear();
        }
    }
}

