/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.CoordinateInterval;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class IntervalDatabase
extends Database<IRecord, Variant> {
    protected final IReaderOption<?> option;
    protected final CCFIntIndexer<Chromosome> indexer;

    public IntervalDatabase(IReaderOption<?> option, CCFIntIndexer<Chromosome> indexer) {
        this.option = option;
        this.indexer = indexer;
        if (this.indexer == null) {
            throw new DatabaseException("Missing coordinate interval indexer for " + this.option.getFile());
        }
    }

    @Override
    public boolean annotate(List<IRecord> resources, long pointer, Variant variant) {
        if (resources != null && resources.size() > 0 && this.contains(variant)) {
            IRecord record = resources.fastGet(0);
            for (FieldMeta field : this.getAllFields()) {
                variant.setProperty(field.fullName(), record.get(field));
            }
        }
        return true;
    }

    @Override
    public Reader instance() throws IOException {
        return new Reader(this);
    }

    public final IReaderOption<?> getReaderOption() {
        return this.option;
    }

    public CoordinateInterval convert(IRecord record) {
        return new CoordinateInterval((Chromosome)record.get("CHROM"), (Integer)record.get("POS_START"), (Integer)record.get("POS_END"));
    }

    private static class RecordPointer {
        final IRecord record;
        final CoordinateInterval interval;
        final long pointer;

        public RecordPointer(IRecord record, CoordinateInterval interval, long pointer) {
            this.record = record;
            this.interval = interval;
            this.pointer = pointer;
        }
    }

    private static class IntervalPointer {
        private final List<RecordPointer> cache = new List();
        private Coordinate coordinate;

        private IntervalPointer() {
        }

        public Coordinate getCoordinate() {
            return this.coordinate;
        }

        public int size() {
            return this.cache.size();
        }

        private void update(Coordinate coordinate) {
            if (coordinate == null) {
                this.coordinate = null;
                this.cache.clear();
                return;
            }
            if (this.coordinate == null) {
                this.coordinate = coordinate;
                this.cache.clear();
                return;
            }
            if (coordinate.equals(this.coordinate)) {
                return;
            }
            if (!this.coordinate.getChromosome().equals(coordinate.getChromosome())) {
                this.coordinate = coordinate;
                this.cache.clear();
            } else {
                this.coordinate = coordinate;
                if (this.cache.size() > 0) {
                    this.cache.retainIf(entry -> entry.interval.contains(coordinate.getPosition()));
                }
            }
        }

        private boolean addInterval(RecordPointer interval) {
            if (interval == null) {
                throw new NullPointerException();
            }
            if (interval.interval.contains(this.coordinate.getPosition())) {
                this.cache.add(interval);
                return true;
            }
            return false;
        }

        private List<IRecord> pack() {
            if (this.coordinate != null) {
                if (this.cache.size() == 0) {
                    return List.EMPTY();
                }
                List<IRecord> values2 = new List<IRecord>(this.cache.size());
                for (RecordPointer record : this.cache) {
                    values2.add(record.record);
                }
                return values2;
            }
            return null;
        }

        private void clear() {
            this.coordinate = null;
            this.cache.clear();
        }
    }

    public static class Reader
    extends Database.Reader<IRecord, Variant, IntervalDatabase> {
        final CCFReader reader;
        final CCFIntIndexer<Chromosome> indexer;
        private final Set<Chromosome> skipped = new HashSet<Chromosome>();
        RecordPointer pointer;
        IntervalPointer intervals = new IntervalPointer();

        private Reader(IntervalDatabase database) throws IOException {
            super(database);
            this.reader = new CCFReader(database.option);
            this.indexer = database.indexer;
        }

        @Override
        public List<IRecord> find(long pointer, Variant variant) throws IOException {
            if (!((IntervalDatabase)this.database).contains(variant)) {
                return List.EMPTY();
            }
            if (variant.getCoordinate().equals(this.intervals.getCoordinate())) {
                return this.intervals.pack();
            }
            RefinedIntBuckets buckets = this.indexer.getTag(variant.getChromosome());
            if (buckets == null) {
                return List.EMPTY();
            }
            if (this.intervals.getCoordinate() == null || !this.intervals.getCoordinate().getChromosome().equals(variant.getChromosome())) {
                if (this.skipped.contains(variant.getChromosome())) {
                    return List.EMPTY();
                }
                this.skipped.add(variant.getChromosome());
                this.reader.seek(buckets.getMinPointer());
            }
            this.intervals.update(variant.getCoordinate());
            while (this.read() != null) {
                if (!this.pointer.interval.getChromosome().equals(variant.getChromosome()) || this.pointer.interval.getStartPosition().getPosition() > variant.getPosition()) {
                    this.reader.seek(this.reader.tell() - 1L);
                    break;
                }
                this.intervals.addInterval(this.pointer);
            }
            return this.intervals.pack();
        }

        @Override
        public boolean annotate(long pointer, Variant variant) throws IOException {
            return ((IntervalDatabase)this.database).annotate(this.find(pointer, variant), pointer, variant);
        }

        @Override
        public void reset() throws IOException {
            this.reader.seek(0L);
            this.skipped.clear();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.skipped.clear();
        }

        private RecordPointer read() throws IOException {
            long pointer = this.reader.tell();
            if (this.pointer != null && this.pointer.pointer == pointer) {
                this.reader.seek(this.reader.tell() + 1L);
                return this.pointer;
            }
            IRecord record = this.reader.read();
            if (record == null) {
                return null;
            }
            this.pointer = new RecordPointer(record, ((IntervalDatabase)this.database).convert(record), pointer);
            return this.pointer;
        }
    }
}

