/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class PointerDatabase<T>
extends Database<BoxRecord, T> {
    final Map<Object, IReaderOption<?>> tables = new THashMap();

    @Override
    public final Database.Reader<BoxRecord, T, PointerDatabase<T>> instance() throws IOException {
        return new Database.Reader<BoxRecord, T, PointerDatabase<T>>(this){
            final Map<Object, TEntry<CCFReader, BoxRecord>> readers;
            final List<BoxRecord> wrapper;
            {
                this.readers = new HashMap<Object, TEntry<CCFReader, BoxRecord>>();
                this.wrapper = new List(1);
                for (Object key : PointerDatabase.this.tables.keySet()) {
                    CCFReader reader = new CCFReader(PointerDatabase.this.tables.get(key));
                    this.readers.put(key, new TEntry<CCFReader, BoxRecord>(reader, reader.getRecord()));
                }
            }

            @Override
            public boolean annotate(long pointer, T target) throws IOException {
                TEntry<CCFReader, BoxRecord> reader = this.readers.get(PointerDatabase.this.getSource(target));
                if (reader == null) {
                    return ((PointerDatabase)this.database).annotate(List.EMPTY(), pointer, target);
                }
                long find = PointerDatabase.this.getPointer(target);
                reader.getKey().seek(find);
                if (reader.getKey().tell() == find && reader.getKey().read(reader.getValue())) {
                    this.wrapper.clear();
                    this.wrapper.add(reader.getValue());
                    return ((PointerDatabase)this.database).annotate(this.wrapper, pointer, target);
                }
                return ((PointerDatabase)this.database).annotate(List.EMPTY(), pointer, target);
            }

            @Override
            public void close() throws IOException {
                for (TEntry<CCFReader, BoxRecord> reader : this.readers.values()) {
                    if (reader == null) continue;
                    reader.getKey().close();
                    reader.getValue().clear();
                }
                this.readers.clear();
            }
        };
    }

    public abstract Object getSource(T var1);

    public abstract long getPointer(T var1);

    public final PointerDatabase<T> addTable(Object id, IReaderOption<?> table) {
        if (id == null || table == null) {
            throw new NullPointerException();
        }
        this.tables.put(id, table);
        return this;
    }

    public final PointerDatabase<T> addTables(Map<?, IReaderOption<?>> tables) {
        if (tables == null) {
            return this;
        }
        this.tables.putAll(tables);
        return this;
    }
}

