/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.annotator;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.container.list.List;
import java.io.IOException;

public abstract class SequentialDatabase<T>
extends Database<BoxRecord, T> {
    final IReaderOption<?> option;

    public SequentialDatabase() {
        this.option = null;
    }

    public SequentialDatabase(IReaderOption<?> option) {
        this.option = option;
    }

    @Override
    public final Database.Reader<BoxRecord, T, SequentialDatabase<T>> instance() throws IOException {
        return new Database.Reader<BoxRecord, T, SequentialDatabase<T>>(this){
            final CCFReader reader;
            final BoxRecord record;
            final List<BoxRecord> wrapper;
            {
                this.reader = SequentialDatabase.this.option == null ? null : new CCFReader(SequentialDatabase.this.option);
                this.record = SequentialDatabase.this.option == null ? null : this.reader.getRecord();
                this.wrapper = SequentialDatabase.this.option == null ? null : new List(1);
            }

            @Override
            public boolean annotate(long pointer, T target) throws IOException {
                if (SequentialDatabase.this.option != null) {
                    this.reader.seek(pointer);
                    if (this.reader.tell() == pointer && this.reader.read(this.record)) {
                        this.wrapper.clear();
                        this.wrapper.add(this.record);
                        return ((SequentialDatabase)this.database).annotate(this.wrapper, pointer, target);
                    }
                    return ((SequentialDatabase)this.database).annotate(List.EMPTY(), pointer, target);
                }
                return ((SequentialDatabase)this.database).annotate(List.EMPTY(), pointer, target);
            }

            @Override
            public void close() throws IOException {
                if (SequentialDatabase.this.option != null) {
                    this.reader.close();
                    this.record.clear();
                }
            }
        };
    }
}

