/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.container.list.List;
import java.io.IOException;

public final class BoxRecord2BoxRecord
implements ILiteConverter<BoxRecord, IRecord> {
    private final ThreadLocal<BoxRecord> containers;
    private final List<IBiSetter<BoxRecord, BoxRecord>> setter = new List();

    public BoxRecord2BoxRecord() {
        this.containers = null;
    }

    public BoxRecord2BoxRecord(Iterable<FieldMeta> fields) {
        this(new FieldGroupMetas(fields).asUnmodifiable());
    }

    public BoxRecord2BoxRecord(IFieldCollection fields) {
        this.containers = ThreadLocal.withInitial(() -> new BoxRecord(fields));
    }

    public BoxRecord2BoxRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.setFromBox(target, (Box<?, ?>)input.getBox(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2BoxRecord setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.setFromBox(target, (Box<?, ?>)input.getBox(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2BoxRecord setValue(FieldMeta source2, String target) {
        this.setter.add((input, output) -> {
            output.setFromBox(target, (Box<?, ?>)input.getBox(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2BoxRecord setValue(FieldMeta source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.setFromBox(target, (Box<?, ?>)input.getBox(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2BoxRecord setValue(IBiSetter<BoxRecord, BoxRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public BoxRecord converter(BoxRecord input) throws IOException {
        BoxRecord output = this.containers == null ? input : this.containers.get();
        if (this.setter.size() > 0) {
            for (IBiSetter<BoxRecord, BoxRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else if (input != output) {
            output.setFrom(input, true);
        }
        return output;
    }
}

