/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;

public final class BoxRecord2TextRecord
implements ILiteConverter<BoxRecord, TextRecord> {
    final ThreadLocal<TextRecord> containers;
    final List<IBiSetter<BoxRecord, TextRecord>> setter = new List();

    public BoxRecord2TextRecord() {
        this.containers = new ThreadLocal();
    }

    public BoxRecord2TextRecord(Iterable<String> fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public BoxRecord2TextRecord(String[] fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public BoxRecord2TextRecord(IndexableSet<String> fields) {
        this.containers = ThreadLocal.withInitial(() -> new TextRecord(fields));
    }

    public BoxRecord2TextRecord setValue(FieldMeta source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, ((Box)input.getBox(source2)).toBytes());
            return true;
        });
        return this;
    }

    public BoxRecord2TextRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, ((Box)input.getBox(source2)).toBytes());
            return true;
        });
        return this;
    }

    public BoxRecord2TextRecord setValue(IBiSetter<BoxRecord, TextRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public TextRecord converter(BoxRecord input) throws IOException {
        TextRecord output = this.containers.get();
        if (output == null) {
            output = new TextRecord(new LinkedSet<String>(input.keys().apply(FieldMeta::fullName, false)));
            this.containers.set(output);
        }
        if (this.setter.size() > 0) {
            for (IBiSetter<BoxRecord, TextRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else {
            for (String key : output.keys()) {
                int index = input.indexOf(key);
                if (index == -1) {
                    output.set(key, Bytes.EMPTY);
                    continue;
                }
                output.set(key, ((Box)input.getBox(index)).toBytes());
            }
        }
        return output;
    }
}

