/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import java.io.IOException;

public final class BoxRecord2Variant
implements ILiteConverter<BoxRecord, Variant> {
    private final List<IBiSetter<BoxRecord, Variant>> setter = new List();
    private LiftOver liftover;

    public BoxRecord2Variant liftover(LiftOver liftover) {
        this.liftover = liftover == null || liftover == LiftOver.ITSELF ? null : liftover;
        return this;
    }

    public BoxRecord2Variant setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.setProperty(target, input.get(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2Variant setValue(FieldMeta source2, String target) {
        this.setter.add((input, output) -> {
            output.setProperty(target, input.get(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2Variant setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.setProperty(target.fullName(), input.get(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2Variant setValue(FieldMeta source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.setProperty(target.fullName(), input.get(source2));
            return true;
        });
        return this;
    }

    public BoxRecord2Variant setValue(IBiSetter<BoxRecord, Variant> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public Variant converter(BoxRecord input) throws IOException {
        VarInt32Box posBox = (VarInt32Box)input.getBox(null, "POS");
        Coordinate coordinate = new Coordinate((Chromosome)input.get(null, "CHROM"), posBox.intValue());
        if (this.liftover != null && (coordinate = this.liftover.convert(coordinate)) == null) {
            return null;
        }
        Variant variant = new Variant(coordinate);
        if (input.containsKey(null, "ALLELE", FieldType.stringIndexableSet)) {
            variant.addAlleles((IndexableSet)input.get("ALLELE"));
        }
        if (input.containsKey(null, "GT", FieldType.bytecode)) {
            variant.setGenotypes(IGenotypes.load((Bytes)input.get(null, "GT")));
        }
        if (this.setter.size() > 0) {
            for (IBiSetter<BoxRecord, Variant> consumer : this.setter) {
                if (consumer.convert(input, variant)) continue;
                return null;
            }
        } else {
            for (FieldMeta field : input.keys()) {
                if (GTBManager.FIELDS.containsField(field)) continue;
                variant.setProperty(field.fullName(), input.get(field));
            }
        }
        return variant;
    }
}

