/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;

public final class TextRecord2BoxRecord
implements ILiteConverter<TextRecord, BoxRecord> {
    final List<IBiSetter<TextRecord, BoxRecord>> setter = new List();
    final ThreadLocal<BoxRecord> containers;

    public TextRecord2BoxRecord() {
        this.containers = new ThreadLocal();
    }

    public TextRecord2BoxRecord(Iterable<FieldMeta> fields) {
        this(new FieldGroupMetas(fields).asUnmodifiable());
    }

    public TextRecord2BoxRecord(IFieldCollection fields) {
        this.containers = ThreadLocal.withInitial(() -> new BoxRecord(fields));
    }

    public TextRecord2BoxRecord setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2BoxRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2BoxRecord setValue(IBiSetter<TextRecord, BoxRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public BoxRecord converter(TextRecord input) throws IOException {
        BoxRecord output = this.containers.get();
        if (output == null) {
            output = new BoxRecord(new FieldGroupMetas(input.keys().apply(key -> FieldMeta.of(key, FieldType.bytecode))));
            this.containers.set(output);
        }
        if (this.setter.size() > 0) {
            for (IBiSetter<TextRecord, BoxRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else {
            for (FieldMeta key2 : output.keys()) {
                int index = input.indexOf(key2.fullName());
                if (index == -1) {
                    output.set(key2, (Object)Bytes.EMPTY);
                    continue;
                }
                ((Box)output.getBox(key2)).char2Object(input.get(index), false);
            }
        }
        return output;
    }
}

