/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;

public final class TextRecord2TextRecord
implements ILiteConverter<TextRecord, TextRecord> {
    final ThreadLocal<TextRecord> containers;
    final List<IBiSetter<TextRecord, TextRecord>> setter = new List();

    public TextRecord2TextRecord() {
        this.containers = null;
    }

    public TextRecord2TextRecord(Iterable<String> fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public TextRecord2TextRecord(String[] fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public TextRecord2TextRecord(IndexableSet<String> fields) {
        this.containers = ThreadLocal.withInitial(() -> new TextRecord(fields));
    }

    public TextRecord2TextRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2TextRecord setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target.fullName(), input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2TextRecord setValue(IBiSetter<TextRecord, TextRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public TextRecord converter(TextRecord input) throws IOException {
        TextRecord output = this.containers == null ? input : this.containers.get();
        if (this.setter.size() > 0) {
            for (IBiSetter<TextRecord, TextRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else if (input != output) {
            output.setFrom(input, true);
        }
        return output;
    }
}

