/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;

public final class TextRecord2Variant
implements ILiteConverter<TextRecord, Variant> {
    final List<IBiSetter<TextRecord, Variant>> setter = new List();
    LiftOver liftover;

    public TextRecord2Variant liftover(LiftOver liftover) {
        this.liftover = liftover == null || liftover == LiftOver.ITSELF ? null : liftover;
        return this;
    }

    public TextRecord2Variant setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.setProperty(target, input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2Variant setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.setProperty(target.fullName(), input.get(source2));
            return true;
        });
        return this;
    }

    public TextRecord2Variant setValue(IBiSetter<TextRecord, Variant> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public Variant converter(TextRecord input) throws IOException {
        Coordinate coordinate = new Coordinate(input.get("CHROM").toString(), input.get("POS").toInt());
        if (this.liftover != null && (coordinate = this.liftover.convert(coordinate)) == null) {
            return null;
        }
        Variant variant = new Variant(coordinate);
        int numOfAlleles = 0;
        if (input.containsKey("REF")) {
            variant.addAllele(input.get("REF").toString());
            ++numOfAlleles;
        }
        if (input.containsKey("ALT")) {
            BytesSplitter splitter = new BytesSplitter(44).init(input.get("ALT"));
            while (splitter.hasNext()) {
                ++numOfAlleles;
                variant.addAllele(splitter.next().toString());
            }
            splitter.clear();
        }
        if (variant.numOfAlleles() != numOfAlleles) {
            throw new InvalidVCFException("Variant " + variant.getCoordinate() + " contains duplicated alternative alleles: \n" + input.values().toString("\t"));
        }
        if (this.setter.size() > 0) {
            for (IBiSetter iBiSetter : this.setter) {
                if (iBiSetter.convert(input, variant)) continue;
                return null;
            }
        } else {
            for (String string : input.keys()) {
                if (string.equals("CHROM") || string.equals("POS") || string.equals("REF") || string.equals("ALE")) continue;
                variant.setProperty(string, input.get(string));
            }
        }
        return variant;
    }
}

