/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import java.io.IOException;

public final class Variant2BoxRecord
implements ILiteConverter<Variant, BoxRecord> {
    private static final IFieldCollection FIELDS = GTBManager.FIELDS.subsetFields("CHROM", "POS", "ALLELE");
    final ThreadLocal<BoxRecord> containers;
    final List<IBiSetter<Variant, BoxRecord>> setter = new List();
    LiftOver liftover;

    public Variant2BoxRecord() {
        this(FIELDS);
    }

    public Variant2BoxRecord(Iterable<FieldMeta> fields) {
        this(new FieldGroupMetas(fields).asUnmodifiable());
    }

    public Variant2BoxRecord(IFieldCollection fields) {
        this.containers = ThreadLocal.withInitial(() -> new BoxRecord(fields));
    }

    public Variant2BoxRecord liftover(LiftOver liftover) {
        this.liftover = liftover == null || liftover == LiftOver.ITSELF ? null : liftover;
        return this;
    }

    public Variant2BoxRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.getPropertyAsString(source2));
            return true;
        });
        return this;
    }

    public Variant2BoxRecord setValue(FieldMeta source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.getPropertyAsString(source2.fullName()));
            return true;
        });
        return this;
    }

    public Variant2BoxRecord setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.getPropertyAsString(source2));
            return true;
        });
        return this;
    }

    public Variant2BoxRecord setValue(FieldMeta source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target, (Object)input.getPropertyAsString(source2.fullName()));
            return true;
        });
        return this;
    }

    public Variant2BoxRecord setValue(IBiSetter<Variant, BoxRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public BoxRecord converter(Variant input) throws IOException {
        if (this.liftover != null && (input = this.liftover.convert(input)) == null) {
            return null;
        }
        BoxRecord output = this.containers.get();
        output.clear();
        if (this.setter.size() > 0) {
            for (IBiSetter<Variant, BoxRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else {
            for (FieldMeta field : output.keys()) {
                if (!FIELDS.containsField(field)) {
                    output.set(field, (Object)input.getPropertyAsString(field.fullName()));
                    continue;
                }
                if (field.fullName().equals("CHROM")) {
                    output.set(null, "CHROM", input.getChromosome());
                    continue;
                }
                if (field.fullName().equals("POS")) {
                    output.set(null, "POS", input.getPosition());
                    continue;
                }
                if (!field.fullName().equals("ALLELE")) continue;
                output.set(null, "ALLELE", input.getAlleles());
            }
        }
        return output;
    }
}

