/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.converter;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.toolkit.converter.IBiSetter;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.IOException;

public final class Variant2TextRecord
implements ILiteConverter<Variant, TextRecord> {
    private static final IndexableSet<String> FIELDS = new LinkedSet<String>(new String[]{"CHROM", "POS", "REF", "ALT", "AC", "AN", "AF"}).asUnmodifiable();
    final ThreadLocal<TextRecord> containers;
    final List<IBiSetter<Variant, TextRecord>> setter = new List();
    LiftOver liftover;

    public Variant2TextRecord() {
        this(FIELDS);
    }

    public Variant2TextRecord(Iterable<String> fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public Variant2TextRecord(String[] fields) {
        this((IndexableSet<String>)new LinkedSet<String>(fields));
    }

    public Variant2TextRecord(IndexableSet<String> fields) {
        this.containers = ThreadLocal.withInitial(() -> new TextRecord(fields));
    }

    public Variant2TextRecord setValue(String source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, input.getPropertyAsString(source2));
            return true;
        });
        return this;
    }

    public Variant2TextRecord setValue(String source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target.fullName(), input.getPropertyAsString(source2));
            return true;
        });
        return this;
    }

    public Variant2TextRecord setValue(FieldMeta source2, String target) {
        this.setter.add((input, output) -> {
            output.set(target, input.getPropertyAsString(source2.fullName()));
            return true;
        });
        return this;
    }

    public Variant2TextRecord setValue(FieldMeta source2, FieldMeta target) {
        this.setter.add((input, output) -> {
            output.set(target.fullName(), input.getPropertyAsString(source2.fullName()));
            return true;
        });
        return this;
    }

    public Variant2TextRecord setValue(IBiSetter<Variant, TextRecord> consumer) {
        if (consumer == null) {
            return this;
        }
        this.setter.add(consumer);
        return this;
    }

    @Override
    public TextRecord converter(Variant input) throws IOException {
        if (this.liftover != null && (input = this.liftover.convert(input)) == null) {
            return null;
        }
        TextRecord output = this.containers.get();
        output.clear();
        if (this.setter.size() > 0) {
            for (IBiSetter<Variant, TextRecord> consumer : this.setter) {
                if (consumer.convert(input, output)) continue;
                return null;
            }
        } else {
            for (String field : output.keys()) {
                if (!FIELDS.contains(field)) {
                    output.set(field, input.getPropertyAsString(field));
                    continue;
                }
                if (field.equals("CHROM")) {
                    output.set(field, input.getChromosome().toBytes());
                    continue;
                }
                if (field.equals("POS")) {
                    output.set(field, input.getPosition());
                    continue;
                }
                if (field.equals("REF")) {
                    if (input.numOfAlleles() >= 1) {
                        output.set("REF", input.alleleOfIndex(0));
                        continue;
                    }
                    output.set("REF", ".");
                    continue;
                }
                if (field.equals("ALT")) {
                    if (input.numOfAlleles() == 2) {
                        output.set("ALT", input.alleleOfIndex(1));
                        continue;
                    }
                    if (input.numOfAlleles() >= 3) {
                        ByteStream builder = ByteStream.getThreadInstance();
                        for (int i = 1; i < input.numOfAlleles(); ++i) {
                            builder.writeChar(input.alleleOfIndex(i));
                            builder.write(44);
                        }
                        builder.wSeek(builder.wTell() - 1);
                        output.set("ALT", builder.toBytes(true));
                        continue;
                    }
                    output.set("ALT", ".");
                    continue;
                }
                if (field.equals("AC")) {
                    output.set(field, input.getGenotypes().counter().getAC());
                    continue;
                }
                if (field.equals("AN")) {
                    output.set(field, input.getGenotypes().counter().getAN());
                    continue;
                }
                if (!field.equals("AF")) continue;
                output.set(field, input.getGenotypes().counter().getAF());
            }
        }
        return output;
    }
}

