/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.File;
import java.io.IOException;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.WigItem;
import org.broad.tribble.util.SeekableStream;

public class BigWigInputOption
implements InputOption<BoxRecord, LiveFile, FieldMeta> {
    private static final IFieldCollection FIELDS = new FieldGroupMeta().addField("CHROM", FieldType.chromosome).addField("POS_START", FieldType.varInt32).addField("POS_END", FieldType.varInt32).addField("VALUE", FieldType.float32).asUnmodifiable();
    final List<IFilter<BoxRecord>> filters = new List();
    final LiveFile file;

    public BigWigInputOption(String input) throws IOException {
        this.file = LiveFile.of(input);
    }

    public BigWigInputOption(File input) throws IOException {
        this.file = LiveFile.of(input);
    }

    public BigWigInputOption(LiveFile input) {
        if (input == null) {
            throw new NullPointerException("Invalid file path: null");
        }
        this.file = input;
    }

    @Override
    public LiveFile getSource() {
        return this.file;
    }

    public IFieldCollection getAllFields() {
        return FIELDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numOfRecords() throws IOException {
        TEntry<SeekableStream, BBFileReader> reader = this.initReader();
        try {
            long l = reader.getValue().getDataCount();
            return l;
        }
        finally {
            reader.getKey().close();
        }
    }

    @Override
    public int numOfFields() throws IOException {
        return FIELDS.numOfFields();
    }

    @Override
    public ICCFMeta getMeta() throws IOException {
        return CCFMeta.EMPTY;
    }

    public BigWigInputOption addFilter(IFilter<BoxRecord> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public BigWigInputOption addFilters(Iterable<IFilter<BoxRecord>> filters) {
        if (filters != null) {
            for (IFilter<BoxRecord> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public BigWigInputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public List<? extends InputProducer<BoxRecord>> getReaders(int nParts) throws IOException {
        return List.singleton(new InputProducer<BoxRecord>(){
            final BoxRecord record = new BoxRecord(BigWigInputOption.access$000());
            final TEntry<SeekableStream, BBFileReader> bigWigReader = BigWigInputOption.access$100(BigWigInputOption.this);
            final BigWigIterator iterator = this.bigWigReader.getValue().getBigWigIterator();
            long pointer = 0L;

            @Override
            public BoxRecord read() throws IOException {
                block0: while (this.iterator.hasNext()) {
                    WigItem record = this.iterator.next();
                    ++this.pointer;
                    this.record.set(null, "CHROM", Chromosome.get(record.getChromosome()));
                    this.record.set(null, "POS_START", record.getStartBase());
                    this.record.set(null, "POS_END", record.getEndBase());
                    this.record.set(null, "VALUE", Float.valueOf(record.getWigValue()));
                    if (BigWigInputOption.this.filters.size() > 0) {
                        for (IFilter<BoxRecord> filter : BigWigInputOption.this.filters) {
                            if (filter.filter(this.record)) continue;
                            continue block0;
                        }
                    }
                    return this.record;
                }
                return null;
            }

            @Override
            public long tell() {
                return this.pointer;
            }

            @Override
            public void close() throws IOException {
                this.bigWigReader.getKey().close();
                this.record.clear();
            }
        });
    }

    private TEntry<SeekableStream, BBFileReader> initReader() throws IOException {
        SeekableStream stream = new SeekableStream(){
            final ISeekableReaderStream reader;
            {
                this.reader = BigWigInputOption.this.file.openAsBinary();
            }

            @Override
            public void seek(long l) throws IOException {
                this.reader.seek(l);
            }

            @Override
            public long position() throws IOException {
                return this.reader.tell();
            }

            @Override
            public boolean eof() throws IOException {
                return this.position() == BigWigInputOption.this.file.length();
            }

            @Override
            public long length() {
                return BigWigInputOption.this.file.length();
            }

            @Override
            public int read() throws IOException {
                return this.reader.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.reader.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.reader.read(b, off, len);
            }

            @Override
            public void close() throws IOException {
                super.close();
                this.reader.close();
            }
        };
        return new TEntry<SeekableStream, BBFileReader>(stream, new BBFileReader(this.file.getPath(), stream));
    }

    static /* synthetic */ IFieldCollection access$000() {
        return FIELDS;
    }

    static /* synthetic */ TEntry access$100(BigWigInputOption x0) throws IOException {
        return x0.initReader();
    }
}

