/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;

public class CCFInputOption
implements InputOption<BoxRecord, IReaderOption<?>, FieldMeta> {
    final IReaderOption<?> option;
    final List<IFilter<BoxRecord>> filters = new List();
    final Pointer pointer;

    public CCFInputOption(String input) throws IOException {
        this.option = new ReaderOption(input, new String[0]).addAllFields();
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public CCFInputOption(File input) throws IOException {
        this.option = new ReaderOption(input, new String[0]).addAllFields();
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public CCFInputOption(LiveFile input) throws IOException {
        this.option = new ReaderOption(input, new String[0]).addAllFields();
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public CCFInputOption(CCFTable input) {
        this.option = new ReaderOption(input, new String[0]).addAllFields();
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public CCFInputOption(IReaderOption<?> option) {
        if (option == null) {
            throw new NullPointerException("Invalid reader option: null");
        }
        this.option = option;
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public CCFInputOption limit(long start, long end) {
        this.pointer.limit(start, end);
        return this;
    }

    public CCFInputOption limit(LongInterval interval) {
        this.pointer.limit(interval);
        return this;
    }

    @Override
    public IReaderOption<?> getSource() {
        return this.option;
    }

    public IFieldCollection getAllFields() {
        return this.option.getAllFields();
    }

    @Override
    public long numOfRecords() {
        return this.option.numOfRecords();
    }

    @Override
    public int numOfFields() {
        return this.option.numOfFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.option.getTable().getMeta();
    }

    public CCFInputOption addFilter(IFilter<BoxRecord> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public CCFInputOption addFilters(Iterable<IFilter<BoxRecord>> filters) {
        if (filters != null) {
            for (IFilter<BoxRecord> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public CCFInputOption clearFilters() {
        this.filters.clear();
        this.pointer.clearLimit();
        return this;
    }

    @Override
    public List<InputProducer<BoxRecord>> getReaders(int nParts) throws IOException {
        List<InputProducer<BoxRecord>> producers = new List<InputProducer<BoxRecord>>();
        List<CCFReader> readers = new CCFReader(this.option).limit(this.pointer.available()).part(nParts);
        for (final CCFReader reader : readers) {
            producers.add(new InputProducer<BoxRecord>(){
                final BoxRecord input;
                {
                    this.input = reader.getRecord();
                }

                @Override
                public BoxRecord read() throws IOException {
                    block0: while (reader.read(this.input)) {
                        if (CCFInputOption.this.filters.size() > 0) {
                            for (IFilter<BoxRecord> filter : CCFInputOption.this.filters) {
                                if (filter.filter(this.input)) continue;
                                continue block0;
                            }
                        }
                        return this.input;
                    }
                    return null;
                }

                @Override
                public long tell() {
                    return reader.tell();
                }

                @Override
                public void close() throws IOException {
                    reader.close();
                    this.input.clear();
                }
            });
        }
        return producers;
    }
}

