/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.filter.GTBFilter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class GTBInputOption
implements InputOption<Variant, GTBReaderOption, FieldMeta> {
    final GTBReaderOption option;
    final List<IFilter<Variant>> filters = new List();
    final Pointer pointer;
    LiftOver liftover = null;
    Map<Chromosome, List<IntInterval>> coordinates;

    public GTBInputOption(String input) throws IOException {
        this.option = new GTBReaderOption(input);
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption(File input) throws IOException {
        this.option = new GTBReaderOption(input);
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption(LiveFile input) throws IOException {
        this.option = new GTBReaderOption(input);
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption(CCFTable input) {
        this.option = new GTBReaderOption(new GTBManager(input));
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption(GTBManager input) {
        this.option = new GTBReaderOption(input);
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption(GTBReaderOption option) {
        if (option == null) {
            throw new NullPointerException("Invalid input option: null");
        }
        this.option = option;
        this.pointer = new Pointer(this.option.numOfRecords());
    }

    public GTBInputOption limit(long start, long end) {
        this.pointer.limit(start, end);
        return this;
    }

    public GTBInputOption limit(LongInterval interval) {
        this.pointer.limit(interval);
        return this;
    }

    public GTBInputOption selectCoordinates(Map<Chromosome, List<IntInterval>> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    public GTBInputOption liftover(LiftOver liftOver) {
        this.liftover = liftOver == null || liftOver == LiftOver.ITSELF ? null : liftOver;
        return this;
    }

    @Override
    public GTBReaderOption getSource() {
        return this.option;
    }

    public IFieldCollection getAllFields() {
        return this.option.getAllFields();
    }

    @Override
    public long numOfRecords() {
        return this.option.numOfRecords();
    }

    @Override
    public int numOfFields() throws IOException {
        return this.option.numOfFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.option.getTable().getMeta();
    }

    public GTBInputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public GTBInputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public GTBInputOption clearFilters() {
        this.filters.clear();
        this.pointer.clearLimit();
        return this;
    }

    @Override
    public List<InputProducer<Variant>> getReaders(int nParts) throws IOException {
        List<InputProducer<Variant>> producers = new List<InputProducer<Variant>>();
        List<GTBReader> readers = new GTBReader(this.option).limit(this.pointer.available()).part(nParts);
        for (final GTBReader reader : readers) {
            final GTBFilter filter = this.coordinates != null ? new GTBFilter(this.option.getGTBManager()).limit(reader.available()).addCoordinateFilter(this.coordinates) : null;
            producers.add(new InputProducer<Variant>(){

                @Override
                public Variant read() throws IOException {
                    if (filter == null) {
                        Variant variant;
                        block0: while ((variant = reader.read()) != null) {
                            if (GTBInputOption.this.liftover != null && (variant = GTBInputOption.this.liftover.convert(variant)) == null) continue;
                            if (GTBInputOption.this.filters.size() > 0) {
                                for (IFilter<Variant> filter2 : GTBInputOption.this.filters) {
                                    if (filter2.filter(variant)) continue;
                                    continue block0;
                                }
                            }
                            return variant;
                        }
                    } else {
                        long pointer;
                        block2: while ((pointer = filter.filter()) != -1L) {
                            reader.seek(pointer);
                            Variant variant = reader.read();
                            if (GTBInputOption.this.liftover != null && (variant = GTBInputOption.this.liftover.convert(variant)) == null) continue;
                            if (GTBInputOption.this.filters.size() > 0) {
                                for (IFilter<Variant> filter3 : GTBInputOption.this.filters) {
                                    if (filter3.filter(variant)) continue;
                                    continue block2;
                                }
                            }
                            return variant;
                        }
                    }
                    return null;
                }

                @Override
                public long tell() {
                    return reader.tell();
                }

                @Override
                public void close() throws IOException {
                    reader.close();
                }
            });
        }
        return producers;
    }

    public IndexableSet<String> getIndividuals() {
        return this.option.getIndividuals();
    }
}

