/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidMAFException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.container.SparseGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Set;

public class MAFInputOption
implements InputOption<Variant, LiveFile, FieldMeta> {
    private static final Set<String> FIELDS = List.wrap("Tumor_Sample_UUID", "Chromosome", "Start_Position", "End_Position", "Reference_Allele", "Tumor_Seq_Allele1", "Tumor_Seq_Allele2", "Tumor_Allele1", "Tumor_Allele2").toUnmodifiableSet();
    final TextReader.Builder reader;
    final IFieldCollection fields;
    final ICCFMeta meta;
    final List<IFilter<Variant>> filters = new List();
    Set<String> individualSelection;
    IndexableSet<String> individuals;
    LiftOver liftOver = null;

    public MAFInputOption(String input) throws IOException {
        this.reader = TextReader.setInput(input).setSeparator(Separator.TAB).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN);
        try (TextReader reader = this.reader.instance();){
            FieldGroupMetas fields = new FieldGroupMetas();
            for (String field : reader.getHeader()) {
                if (FIELDS.contains(field)) continue;
                fields.addField(field, FieldType.bytecode);
            }
            this.fields = fields.asUnmodifiable();
            this.meta = reader.getMeta();
        }
    }

    public MAFInputOption(File input) throws IOException {
        this.reader = TextReader.setInput(input).setSeparator(Separator.TAB).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN);
        try (TextReader reader = this.reader.instance();){
            FieldGroupMetas fields = new FieldGroupMetas();
            for (String field : reader.getHeader()) {
                if (FIELDS.contains(field)) continue;
                fields.addField(field, FieldType.bytecode);
            }
            this.fields = fields.asUnmodifiable();
            this.meta = reader.getMeta();
        }
    }

    public MAFInputOption(LiveFile input) throws IOException {
        this.reader = TextReader.setInput(input).setSeparator(Separator.TAB).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN);
        try (TextReader reader = this.reader.instance();){
            FieldGroupMetas fields = new FieldGroupMetas();
            for (String field : reader.getHeader()) {
                if (FIELDS.contains(field)) continue;
                fields.addField(field, FieldType.bytecode);
            }
            this.fields = fields.asUnmodifiable();
            this.meta = reader.getMeta();
        }
    }

    public MAFInputOption liftover(LiftOver liftOver) {
        this.liftOver = liftOver == null || liftOver == LiftOver.ITSELF ? null : liftOver;
        return this;
    }

    @Override
    public LiveFile getSource() {
        return this.reader.getFile();
    }

    public IFieldCollection getAllFields() {
        return this.fields;
    }

    @Override
    public long numOfRecords() {
        return -1L;
    }

    @Override
    public int numOfFields() throws IOException {
        return this.fields.numOfFields();
    }

    @Override
    public ICCFMeta getMeta() throws IOException {
        return this.meta;
    }

    public MAFInputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public MAFInputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public MAFInputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public List<InputProducer<Variant>> getReaders(int nParts) throws IOException {
        final List<TEntry<String, FieldMeta>> mapper = new List<TEntry<String, FieldMeta>>();
        try (TextReader reader2 = this.reader.instance();){
            for (String field : reader2.getHeader()) {
                if (FIELDS.contains(field)) continue;
                FieldMeta meta = FieldMeta.of(field, FieldType.bytecode);
                mapper.add(new TEntry<String, FieldMeta>(field, meta));
            }
        }
        this.getIndividuals();
        final boolean load = this.individuals.hasOverlaps(this.individualSelection);
        return this.reader.instance(nParts).apply(reader -> new InputProducer<Variant>(){
            final TextRecord input;
            {
                this.input = reader.getRecord();
            }

            @Override
            public Variant read() throws IOException {
                if (!load) {
                    return null;
                }
                block0: while (reader.read(this.input)) {
                    String UUID2 = this.input.get("Tumor_Sample_UUID").toString();
                    if (MAFInputOption.this.individualSelection != null && !MAFInputOption.this.individualSelection.contains(UUID2)) continue;
                    Chromosome chromosome = Chromosome.get(this.input.get("Chromosome").toString());
                    int position = this.input.get("Start_Position").toInt();
                    Variant variant = new Variant(new Coordinate(chromosome, position));
                    if (MAFInputOption.this.liftOver != null && (variant = MAFInputOption.this.liftOver.convert(variant)) == null) continue;
                    variant.addAllele(this.input.get("Reference_Allele").toString());
                    String allele1 = this.input.gets("Tumor_Seq_Allele1", "Tumor_Allele1").toString();
                    String allele2 = this.input.gets("Tumor_Seq_Allele2", "Tumor_Allele2").toString();
                    variant.addAllele(allele1);
                    variant.addAllele(allele2);
                    for (TEntry tEntry : mapper) {
                        variant.setProperty(((FieldMeta)tEntry.getValue()).fullName(), this.input.get((String)tEntry.getKey()));
                    }
                    variant.setGenotypes(new SparseGenotypes(MAFInputOption.this.individuals.size()).set(MAFInputOption.this.individuals.indexOf(UUID2), Genotype.of(variant.indexOfAllele(allele1), variant.indexOfAllele(allele2))));
                    if (MAFInputOption.this.filters.size() > 0) {
                        for (IFilter iFilter : MAFInputOption.this.filters) {
                            if (iFilter.filter(variant)) continue;
                            continue block0;
                        }
                    }
                    return variant;
                }
                return null;
            }

            @Override
            public long tell() {
                return reader.tell();
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IndexableSet<String> getIndividuals() {
        if (this.individuals != null) return this.individuals;
        try (TextReader reader = this.reader.instance();){
            TextRecord record;
            LinkedSet<String> individuals = new LinkedSet<String>();
            while ((record = reader.read()) != null) {
                String UID = record.get("Tumor_Sample_UUID").toString();
                if (!VCFHeader.isValidIndividual(UID)) {
                    throw new InvalidIndividualException("Invalid individual: " + UID);
                }
                if (((IndexableSet)individuals).indexOf(UID) != -1) continue;
                ((AbstractCollection)individuals).add(UID);
            }
            this.individuals = individuals.asUnmodifiable();
            IndexableSet<String> indexableSet = this.individuals;
            return indexableSet;
        }
        catch (IOException e) {
            throw new InvalidMAFException(e.getMessage(), e);
        }
    }

    public MAFInputOption selectIndividuals(Iterable<String> individuals) {
        if (individuals == null) {
            this.individualSelection = null;
            return this;
        }
        if (this.individualSelection == null) {
            this.individualSelection = new THashSet<String>();
        } else {
            this.individualSelection.clear();
        }
        for (String individual : individuals) {
            this.individualSelection.add(individual);
        }
        return this;
    }
}

