/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PLINKInputOption
implements InputOption<Variant, PLINKFile, FieldMeta> {
    final PLINKFile file;
    final List<IFilter<Variant>> filters = new List();
    final boolean loadGenotype;
    final Pointer pointer;
    LiftOver liftover = null;

    public PLINKInputOption(String input) throws IOException {
        this(input, true);
    }

    public PLINKInputOption(String input, boolean loadGenotype) throws IOException {
        if (LiveFile.exists(input + ".bed")) {
            this.file = PLINKFile.load(input, PLINKType.BED);
        } else if (LiveFile.exists(input + ".pgen")) {
            this.file = PLINKFile.load(input, PLINKType.PGEN);
        } else {
            throw new FileNotFoundException(input + ".bed or " + input + ".pgen");
        }
        this.loadGenotype = loadGenotype;
        this.pointer = new Pointer(this.file.numOfVariants());
    }

    public PLINKInputOption(String input, PLINKType type) throws IOException {
        this(PLINKFile.load(input, type), true);
    }

    public PLINKInputOption(String input, PLINKType type, boolean loadGenotype) throws IOException {
        this(PLINKFile.load(input, type), loadGenotype);
    }

    public PLINKInputOption(PLINKFile input) {
        this(input, true);
    }

    public PLINKInputOption(PLINKFile input, boolean loadGenotype) {
        if (input == null) {
            throw new NullPointerException("Invalid input file: null");
        }
        this.file = input;
        this.loadGenotype = loadGenotype;
        this.pointer = new Pointer(this.file.numOfVariants());
    }

    public PLINKInputOption liftover(LiftOver liftOver) {
        this.liftover = liftOver == null || liftOver == LiftOver.ITSELF ? null : liftOver;
        return this;
    }

    public PLINKInputOption limit(long start, long end) {
        this.pointer.limit(start, end);
        return this;
    }

    public PLINKInputOption limit(LongInterval interval) {
        this.pointer.limit(interval);
        return this;
    }

    @Override
    public PLINKFile getSource() throws IOException {
        return this.file;
    }

    public IFieldCollection getAllFields() {
        return this.file.getAllFields();
    }

    @Override
    public long numOfRecords() {
        return this.file.numOfVariants();
    }

    @Override
    public int numOfFields() throws IOException {
        return this.file.getIndexer().numOfFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.file.getMeta();
    }

    public PLINKInputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public PLINKInputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public PLINKInputOption clearFilters() {
        this.filters.clear();
        this.pointer.clearLimit();
        return this;
    }

    @Override
    public List<InputProducer<Variant>> getReaders(int nParts) throws IOException {
        List<InputProducer<Variant>> producers = new List<InputProducer<Variant>>();
        List<PLINKReader> readers = this.file.instance(this.loadGenotype).limit(this.pointer.available()).part(nParts);
        for (final PLINKReader reader : readers) {
            producers.add(new InputProducer<Variant>(){

                @Override
                public Variant read() throws IOException {
                    Variant variant;
                    block0: while ((variant = reader.read()) != null) {
                        if (PLINKInputOption.this.liftover != null && (variant = PLINKInputOption.this.liftover.convert(variant)) == null) continue;
                        if (PLINKInputOption.this.filters.size() > 0) {
                            for (IFilter<Variant> filter : PLINKInputOption.this.filters) {
                                if (filter.filter(variant)) continue;
                                continue block0;
                            }
                        }
                        return variant;
                    }
                    return null;
                }

                @Override
                public long tell() {
                    return reader.tell();
                }

                @Override
                public void close() throws IOException {
                    reader.close();
                }
            });
        }
        return producers;
    }

    public IndexableSet<String> getIndividuals() {
        if (this.loadGenotype) {
            return this.file.getIndividuals();
        }
        return IndexableSet.EMPTY();
    }
}

