/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.File;
import java.io.IOException;

public class TextInputOption
implements InputOption<TextRecord, LiveFile, String> {
    final TextReader.Builder reader;
    IndexableSet<String> fields;
    final List<IFilter<TextRecord>> filters = new List();

    public TextInputOption(String input) throws IOException {
        this.reader = TextReader.setInput(input);
    }

    public TextInputOption(File input) throws IOException {
        this.reader = TextReader.setInput(input);
    }

    public TextInputOption(LiveFile input) {
        this.reader = TextReader.setInput(input);
    }

    public TextInputOption(TextReader.Builder option) {
        if (option == null) {
            throw new NullPointerException("Invalid reader option: null");
        }
        this.reader = option;
    }

    public TextInputOption setSeparator(ISeparator separator) {
        this.reader.setSeparator(separator);
        return this;
    }

    public TextInputOption setHeaderParser(IHeaderParser headerParser) {
        this.reader.setHeaderParser(headerParser);
        return this;
    }

    public TextInputOption setMetadataParser(IMetadataParser metadataParser) {
        this.reader.setMetadataParser(metadataParser);
        return this;
    }

    @Override
    public LiveFile getSource() {
        return this.reader.getFile();
    }

    @Override
    public synchronized IndexableSet<String> getAllFields() throws IOException {
        if (this.fields == null) {
            try (TextReader reader = this.reader.instance();){
                this.fields = reader.getHeader();
                IndexableSet<String> indexableSet = this.fields;
                return indexableSet;
            }
        }
        return this.fields;
    }

    @Override
    public long numOfRecords() {
        return -1L;
    }

    @Override
    public int numOfFields() throws IOException {
        return this.fields.size();
    }

    @Override
    public ICCFMeta getMeta() throws IOException {
        try (TextReader reader = this.reader.instance();){
            ICCFMeta iCCFMeta = reader.getMeta();
            return iCCFMeta;
        }
    }

    public TextInputOption addFilter(IFilter<TextRecord> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public TextInputOption addFilters(Iterable<IFilter<TextRecord>> filters) {
        if (filters != null) {
            for (IFilter<TextRecord> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    @Override
    public InputOption<TextRecord, LiveFile, String> clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public List<? extends InputProducer<TextRecord>> getReaders(int nParts) throws IOException {
        return this.reader.instance(nParts).apply(reader -> new InputProducer<TextRecord>(){
            final TextRecord input;
            {
                this.input = reader.getRecord();
            }

            @Override
            public TextRecord read() throws IOException {
                if (TextInputOption.this.filters.size() == 0) {
                    if (reader.read(this.input)) {
                        return this.input;
                    }
                } else {
                    block0: while (reader.read(this.input)) {
                        for (IFilter<TextRecord> filter : TextInputOption.this.filters) {
                            if (filter.filter(this.input)) continue;
                            continue block0;
                        }
                        return this.input;
                    }
                }
                return null;
            }

            @Override
            public long tell() {
                return reader.tell();
            }

            @Override
            public void close() throws IOException {
                reader.close();
                this.input.clear();
            }
        });
    }
}

