/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.input;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.input.InputOption;
import edu.sysu.pmglab.ccf.toolkit.input.InputProducer;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFReader;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.INFOParser;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.IntFunction;

public class VCFInputOption
implements InputOption<Variant, LiveFile, FieldMeta> {
    final VCFReader.Builder reader;
    final IndexableSet<String> individuals;
    final ICCFMeta meta;
    final List<IFilter<Variant>> filters = new List();

    public VCFInputOption(String input) throws IOException {
        this.reader = VCFReader.setInput(input);
        try (VCFReader reader = this.reader.instance();){
            this.individuals = reader.getIndividuals();
            this.meta = reader.getMeta();
        }
    }

    public VCFInputOption(File input) throws IOException {
        this.reader = VCFReader.setInput(input);
        try (VCFReader reader = this.reader.instance();){
            this.individuals = reader.getIndividuals();
            this.meta = reader.getMeta();
        }
    }

    public VCFInputOption(LiveFile input) throws IOException {
        this.reader = VCFReader.setInput(input);
        try (VCFReader reader = this.reader.instance();){
            this.individuals = reader.getIndividuals();
            this.meta = reader.getMeta();
        }
    }

    public VCFInputOption(VCFReader.Builder option) throws IOException {
        if (option == null) {
            throw new NullPointerException("Invalid reader option: null");
        }
        this.reader = option;
        try (VCFReader reader = this.reader.instance();){
            this.individuals = reader.getIndividuals();
            this.meta = reader.getMeta();
        }
    }

    public VCFInputOption setGenotypeParser(IntFunction<IGenotypeParser> parser) {
        this.reader.setGenotypeParser(parser);
        return this;
    }

    public VCFInputOption setInfoParser(INFOParser infoParser) {
        this.reader.setInfoParser(infoParser);
        return this;
    }

    @Override
    public LiveFile getSource() {
        return this.reader.getFile();
    }

    public FieldGroupMeta getAllFields() {
        return this.reader.getAllFields();
    }

    @Override
    public long numOfRecords() {
        return -1L;
    }

    @Override
    public int numOfFields() throws IOException {
        return this.getAllFields().numOfFields();
    }

    @Override
    public ICCFMeta getMeta() throws IOException {
        return this.meta;
    }

    public VCFInputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public VCFInputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public VCFInputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public List<InputProducer<Variant>> getReaders(int nParts) throws IOException {
        return this.reader.instance(nParts).apply(reader -> new InputProducer<Variant>(){

            @Override
            public Variant read() throws IOException {
                Variant variant;
                block0: while ((variant = reader.read()) != null) {
                    if (VCFInputOption.this.filters.size() > 0) {
                        for (IFilter<Variant> filter : VCFInputOption.this.filters) {
                            if (filter.filter(variant)) continue;
                            continue block0;
                        }
                    }
                    return variant;
                }
                return null;
            }

            @Override
            public long tell() {
                return reader.tell();
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        });
    }

    public VCFInputOption addInputPreFilter(Function<Variant, Variant> filter) {
        this.reader.addFilter(filter);
        return this;
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }
}

