/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.ccf.CCFConfiguration;
import edu.sysu.pmglab.ccf.CCFWriter;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Configurator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;

public class CCFOutputOption
implements OutputOption<IRecord, FieldMeta> {
    final CCFWriter.Builder output;
    final CCFMeta meta = new CCFMeta();
    final CCFOptions options = new CCFOptions();
    final List<IFilter<IRecord>> filters = new List();

    public CCFOutputOption(String output) throws FileSystemException {
        this(new File(output));
    }

    public CCFOutputOption(File output) throws FileSystemException {
        if (output == null) {
            throw new IllegalArgumentException("Illegal file path: null");
        }
        if (output.isDirectory()) {
            throw new FileSystemException(output + " Is a directory");
        }
        this.output = CCFWriter.setOutput(output);
    }

    public CCFOutputOption addField(FieldMeta field) {
        this.output.addField(field);
        return this;
    }

    public CCFOutputOption addField(String name, IFieldType type) {
        this.output.addField(name, type);
        return this;
    }

    public CCFOutputOption addField(String group, String name, IFieldType type) {
        return this.addField(FieldMeta.of(group, name, type));
    }

    public CCFOutputOption addFields(Iterable<FieldMeta> fields) {
        this.output.addFields(fields);
        return this;
    }

    public CCFOutputOption addFields(FieldMeta ... fields) {
        if (fields != null) {
            for (FieldMeta field : fields) {
                if (field == null) continue;
                this.addField(field);
            }
        }
        return this;
    }

    public CCFOutputOption clearFields() {
        this.output.clearFields();
        return this;
    }

    @Override
    public String getFile() {
        return this.output.getFile().getPath();
    }

    public IFieldCollection getAllFields() {
        return this.output.getAllFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.meta.asUnmodifiable();
    }

    @Override
    public ICCFOptions getOptions() {
        return this.options.asUnmodifiable();
    }

    public CCFOutputOption addFilter(IFilter<IRecord> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public CCFOutputOption addFilters(Iterable<IFilter<IRecord>> filters) {
        if (filters != null) {
            for (IFilter<IRecord> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public CCFOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<IRecord> getWriters(int nParts) throws IOException {
        final CCFWriter writers = this.output.instance(nParts);
        return new OutputConsumer<IRecord>(){

            @Override
            public int write(int index, IRecord input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (CCFOutputOption.this.filters.size() > 0) {
                    for (IFilter<IRecord> filter : CCFOutputOption.this.filters) {
                        if (filter.filter(input)) continue;
                        return 0;
                    }
                }
                writers.write(index, input);
                return 1;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public synchronized void close() throws IOException {
                if (!writers.isClosed()) {
                    writers.addMeta(CCFOutputOption.this.meta);
                    writers.addOptions(CCFOutputOption.this.options);
                    writers.close();
                }
            }
        };
    }

    public CCFOutputOption dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public CCFOutputOption clearMeta() {
        this.meta.clear();
        return this;
    }

    public CCFOutputOption clearOptions() {
        this.options.clear();
        return this;
    }

    public CCFOutputOption addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public CCFOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.meta.adds(meta);
        return this;
    }

    public CCFOutputOption addOption(CCFMetaItem option) {
        this.options.add(option);
        return this;
    }

    public CCFOutputOption addOptions(Iterable<CCFMetaItem> option) {
        this.options.adds(option);
        return this;
    }

    public CCFOutputOption configureFileOptions(Configurator<CCFConfiguration> configurator) {
        this.output.configureFileOptions(configurator);
        return this;
    }
}

