/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.ccf.CCFConfiguration;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.utils.Configurator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;

public class GTBOutputOption
implements OutputOption<Variant, FieldMeta> {
    final GTBWriter.Builder output;
    final CCFMeta meta = new CCFMeta();
    final CCFOptions options = new CCFOptions();
    final List<IFilter<Variant>> filters = new List();

    public GTBOutputOption(String output) throws FileSystemException {
        this(new File(output));
    }

    public GTBOutputOption(File output) throws FileSystemException {
        if (output == null) {
            throw new IllegalArgumentException("Illegal file path: null");
        }
        if (output.isDirectory()) {
            throw new FileSystemException(output + " Is a directory");
        }
        this.output = GTBWriter.setOutput(output);
    }

    public GTBOutputOption addField(FieldMeta field) {
        this.output.addField(field);
        return this;
    }

    public GTBOutputOption addField(String name, IFieldType type) {
        return this.addField(FieldMeta.of(name, type));
    }

    public GTBOutputOption addField(String group, String name, IFieldType type) {
        return this.addField(FieldMeta.of(group, name, type));
    }

    public GTBOutputOption addFields(Iterable<FieldMeta> fields) {
        this.output.addFields(fields);
        return this;
    }

    public GTBOutputOption addFields(FieldMeta ... fields) {
        this.output.addFields(fields);
        return this;
    }

    public GTBOutputOption clearFields() {
        this.output.clearFields();
        return this;
    }

    @Override
    public String getFile() {
        return this.output.getFile().getPath();
    }

    public IFieldCollection getAllFields() {
        return this.output.getAllFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.meta.asUnmodifiable();
    }

    @Override
    public ICCFOptions getOptions() {
        return this.options.asUnmodifiable();
    }

    public GTBOutputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public GTBOutputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public GTBOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<Variant> getWriters(int nParts) throws IOException {
        final GTBWriter writers = this.output.instance(nParts);
        return new OutputConsumer<Variant>(){

            @Override
            public int write(int index, Variant input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (GTBOutputOption.this.filters.size() > 0) {
                    for (IFilter<Variant> filter : GTBOutputOption.this.filters) {
                        if (filter.filter(input)) continue;
                        return 0;
                    }
                }
                writers.write(index, input);
                return 1;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public synchronized void close() throws IOException {
                if (!writers.isClosed()) {
                    writers.addMeta(GTBOutputOption.this.meta);
                    writers.addOptions(GTBOutputOption.this.options);
                    writers.close();
                }
            }
        };
    }

    public GTBOutputOption dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public GTBOutputOption clearMeta() {
        this.meta.clear();
        return this;
    }

    public GTBOutputOption clearOptions() {
        this.options.clear();
        return this;
    }

    public GTBOutputOption addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public GTBOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.meta.adds(meta);
        return this;
    }

    public GTBOutputOption addOption(CCFMetaItem option) {
        this.options.add(option);
        return this;
    }

    public GTBOutputOption addOptions(Iterable<CCFMetaItem> option) {
        this.options.adds(option);
        return this;
    }

    public GTBOutputOption clearIndividuals() {
        this.output.clearIndividuals();
        return this;
    }

    public GTBOutputOption addIndividual(String individual) {
        this.output.addIndividual(individual);
        return this;
    }

    public GTBOutputOption addIndividuals(String ... individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public GTBOutputOption addIndividuals(Iterable<String> individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public IndexableSet<String> getIndividuals() {
        return this.output.getIndividuals();
    }

    public GTBOutputOption setIndividuals(Iterable<String> individuals) {
        this.output.setIndividuals(individuals);
        return this;
    }

    public int numOfIndividuals() {
        return this.output.numOfIndividuals();
    }

    public GTBOutputOption configureFileOptions(Configurator<CCFConfiguration> configurator) {
        this.output.configureFileOptions(configurator);
        return this;
    }
}

