/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.Joiner;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class MAFOutputOption
implements OutputOption<Variant, String> {
    private static final Set<String> FIELDS = List.wrap("Tumor_Sample_UUID", "Chromosome", "Start_Position", "Reference_Allele", "Tumor_Seq_Allele1", "Tumor_Seq_Allele2").toUnmodifiableSet();
    final TextWriter.Builder output;
    final IndexableSet<String> individuals = new LinkedSet<String>();
    final List<IFilter<Variant>> filters = new List();
    IFilter<Genotype> filter = null;

    public MAFOutputOption() {
        this(TextWriter.stdout());
    }

    public MAFOutputOption(String path) {
        this(TextWriter.setOutput(path));
    }

    public MAFOutputOption(File path) {
        this(TextWriter.setOutput(path));
    }

    private MAFOutputOption(TextWriter.Builder builder) {
        this.output = builder.setValueJoiner(Joiner.TAB).setHeaderFormatter(IHeaderFormatter.DIRECTLY).setMetadataFormatter((metas, container) -> {
            boolean empty = true;
            for (CCFMetaItem item : metas) {
                if (!empty) {
                    container.write(10);
                }
                empty = false;
                container.write(35);
                container.write(35);
                container.write(32);
                container.writeChar(item.toString());
            }
            return !empty;
        }).addFields(FIELDS);
    }

    public MAFOutputOption setCompressionLevel(int level) {
        this.output.setCompressionLevel(level);
        return this;
    }

    public int getCompressorLevel() {
        return this.output.getCompressorLevel();
    }

    public boolean isCompressionEnabled() {
        return this.output.isCompressionEnabled();
    }

    public MAFOutputOption addField(String field) {
        this.output.addField(field);
        return this;
    }

    public MAFOutputOption addFields(String ... fields) {
        this.output.addFields(fields);
        return this;
    }

    public MAFOutputOption addFields(Iterable<String> fields) {
        this.output.addFields(fields);
        return this;
    }

    public MAFOutputOption clearFields() {
        this.output.clearFields();
        this.output.addFields(FIELDS);
        return this;
    }

    public boolean containsField(String field) {
        return this.output.containsField(field);
    }

    public MAFOutputOption filterGenotype(IFilter<Genotype> filter) {
        this.filter = filter;
        return this;
    }

    public MAFOutputOption dropDuplicateMeta() {
        this.output.dropDuplicateMetas();
        return this;
    }

    public MAFOutputOption clearMeta() {
        this.output.clearMetas();
        return this;
    }

    public MAFOutputOption addMeta(CCFMetaItem meta) {
        this.output.addMeta(meta);
        return this;
    }

    public MAFOutputOption addMeta(String key) {
        this.output.addMeta(key);
        return this;
    }

    public MAFOutputOption addMeta(String key, String value) {
        this.output.addMeta(key, value);
        return this;
    }

    public MAFOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.output.addMeta(meta);
        return this;
    }

    @Override
    public String getFile() {
        return this.output.getFile() == null ? null : this.output.getFile().getPath();
    }

    @Override
    public IndexableSet<String> getAllFields() {
        return this.output.getAllFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.output.getMeta();
    }

    public MAFOutputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public MAFOutputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public MAFOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<Variant> getWriters(int nParts) throws IOException {
        final TextWriter writers = this.output.instance(nParts);
        return new OutputConsumer<Variant>(){
            final ThreadLocal<TextRecord> records = ThreadLocal.withInitial(writers::getRecord);

            @Override
            public int write(int index, Variant input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (input.numOfAlleles() >= 2 && MAFOutputOption.this.individuals.size() > 0) {
                    if (MAFOutputOption.this.filters.size() > 0) {
                        for (IFilter<Variant> filter : MAFOutputOption.this.filters) {
                            if (filter.filter(input)) continue;
                            return 0;
                        }
                    }
                    TextRecord record = this.records.get();
                    record.set("Chromosome", input.getChromosome().toBytes());
                    record.set("Start_Position", new Bytes(ASCIIUtility.toASCII(input.getPosition())));
                    record.set("Reference_Allele", input.alleleOfIndex(0));
                    IGenotypes genotypes = input.getGenotypes();
                    IndexIterator iterator2 = genotypes.where(genotype -> genotype.getAN() == 2 && genotype.getAC() >= 1 && (MAFOutputOption.this.filter == null || MAFOutputOption.this.filter.filter((Genotype)genotype)));
                    int count = 0;
                    while (iterator2.hasNext()) {
                        int gtIndex = iterator2.next();
                        record.set("Tumor_Sample_UUID", MAFOutputOption.this.individuals.valueOf(gtIndex));
                        Genotype genotype2 = genotypes.get(gtIndex);
                        record.set("Tumor_Seq_Allele1", input.alleleOfIndex(genotype2.left()));
                        record.set("Tumor_Seq_Allele2", input.alleleOfIndex(genotype2.right()));
                        if (record.size() > FIELDS.size()) {
                            int l = record.size();
                            for (int i = 0; i < l; ++i) {
                                String field = record.keyOf(i);
                                if (FIELDS.contains(field)) continue;
                                record.set(field, input.getPropertyAsString(field));
                            }
                        }
                        writers.write(index, record);
                        ++count;
                    }
                    return count;
                }
                return 0;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public void close() throws IOException {
                writers.close();
            }
        };
    }

    public MAFOutputOption clearIndividuals() {
        this.individuals.clear();
        return this;
    }

    public MAFOutputOption addIndividual(String individual) {
        if (!VCFHeader.isValidIndividual(individual)) {
            throw new InvalidIndividualException("Invalid individual: " + individual);
        }
        this.individuals.add(individual);
        return this;
    }

    public MAFOutputOption addIndividuals(String ... individuals) {
        if (individuals != null) {
            for (String individual : individuals) {
                if (!VCFHeader.isValidIndividual(individual)) {
                    throw new InvalidIndividualException("Invalid individual: " + individual);
                }
                this.individuals.add(individual);
            }
        }
        return this;
    }

    public MAFOutputOption addIndividuals(Iterable<String> individuals) {
        if (individuals != null) {
            for (String individual : individuals) {
                if (!VCFHeader.isValidIndividual(individual)) {
                    throw new InvalidIndividualException("Invalid individual: " + individual);
                }
                this.individuals.add(individual);
            }
        }
        return this;
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals.asUnmodifiable();
    }

    public MAFOutputOption setIndividuals(Iterable<String> individuals) {
        this.individuals.clear();
        if (individuals != null) {
            for (String individual : individuals) {
                if (!VCFHeader.isValidIndividual(individual)) {
                    throw new InvalidIndividualException("Invalid individual: " + individual);
                }
                this.individuals.add(individual);
            }
        }
        return this;
    }

    public int numOfIndividuals() {
        return this.individuals.size();
    }
}

