/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKWriter;
import java.io.IOException;

public class PLINKOutputOption
implements OutputOption<Variant, String> {
    final PLINKWriter.Builder output;
    final List<IFilter<Variant>> filters = new List();

    public PLINKOutputOption(String path) {
        this(path, PLINKType.PGEN);
    }

    public PLINKOutputOption(String path, PLINKType type) {
        this.output = PLINKWriter.setOutput(path, type);
    }

    @Override
    public String getFile() {
        return this.output.getFile();
    }

    @Override
    public Iterable<String> getAllFields() {
        return IndexableSet.EMPTY();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.output.getMeta();
    }

    public PLINKOutputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public PLINKOutputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public PLINKOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<Variant> getWriters(int nParts) throws IOException {
        final PLINKWriter writers = this.output.instance(nParts);
        return new OutputConsumer<Variant>(){

            @Override
            public int write(int index, Variant input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (PLINKOutputOption.this.filters.size() > 0) {
                    for (IFilter<Variant> filter : PLINKOutputOption.this.filters) {
                        if (filter.filter(input)) continue;
                        return 0;
                    }
                }
                writers.write(index, input);
                return 1;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public void close() throws IOException {
                if (!writers.isClosed()) {
                    writers.close();
                }
            }
        };
    }

    public PLINKOutputOption dropDuplicateMeta() {
        this.output.dropDuplicateMetas();
        return this;
    }

    public PLINKOutputOption clearMeta() {
        this.output.clearMetas();
        return this;
    }

    public PLINKOutputOption addMeta(CCFMetaItem meta) {
        this.output.addMeta(meta);
        return this;
    }

    public PLINKOutputOption addMeta(String key) {
        this.output.addMeta(key);
        return this;
    }

    public PLINKOutputOption addMeta(String key, String value) {
        this.output.addMeta(key, value);
        return this;
    }

    public PLINKOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.output.addMeta(meta);
        return this;
    }

    public PLINKOutputOption clearIndividuals() {
        this.output.clearIndividuals();
        return this;
    }

    public PLINKOutputOption addIndividual(String individual) {
        this.output.addIndividual(individual);
        return this;
    }

    public PLINKOutputOption addIndividuals(String ... individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public PLINKOutputOption addIndividuals(Iterable<String> individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public IndexableSet<String> getIndividuals() {
        return this.output.getIndividuals();
    }

    public PLINKOutputOption setIndividuals(Iterable<String> individuals) {
        this.output.setIndividuals(individuals);
        return this;
    }

    public int numOfIndividuals() {
        return this.output.numOfIndividuals();
    }

    public PLINKType getType() {
        return this.output.getType();
    }
}

