/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.IJoiner;
import edu.sysu.pmglab.io.text.writer.IMetadataFormatter;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import java.io.File;
import java.io.IOException;

public class TextOutputOption
implements OutputOption<TextRecord, String> {
    final TextWriter.Builder output;
    final List<IFilter<TextRecord>> filters = new List();

    public TextOutputOption() {
        this.output = TextWriter.stdout();
    }

    public TextOutputOption(String path) {
        this.output = TextWriter.setOutput(path);
    }

    public TextOutputOption(File path) {
        this.output = TextWriter.setOutput(path);
    }

    public TextOutputOption(TextWriter.Builder option) {
        if (option == null) {
            throw new NullPointerException("Invalid output: null");
        }
        this.output = option;
    }

    public TextOutputOption setCompressionLevel(int level) {
        this.output.setCompressionLevel(level);
        return this;
    }

    public int getCompressorLevel() {
        return this.output.getCompressorLevel();
    }

    public boolean isCompressionEnabled() {
        return this.output.isCompressionEnabled();
    }

    public TextOutputOption setValueJoiner(IJoiner joiner) {
        this.output.setValueJoiner(joiner);
        return this;
    }

    public TextOutputOption setHeaderFormatter(IHeaderFormatter headerFormatter) {
        this.output.setHeaderFormatter(headerFormatter);
        return this;
    }

    public TextOutputOption setMetadataFormatter(IMetadataFormatter metadataParser) {
        this.output.setMetadataFormatter(metadataParser);
        return this;
    }

    public TextOutputOption addField(String field) {
        this.output.addField(field);
        return this;
    }

    public TextOutputOption addFields(String ... fields) {
        this.output.addFields(fields);
        return this;
    }

    public TextOutputOption addFields(Iterable<String> fields) {
        this.output.addFields(fields);
        return this;
    }

    public TextOutputOption clearFields() {
        this.output.clearFields();
        return this;
    }

    @Override
    public String getFile() {
        return this.output.getFile() == null ? null : this.output.getFile().getPath();
    }

    @Override
    public IndexableSet<String> getAllFields() {
        return this.output.getAllFields();
    }

    @Override
    public ICCFMeta getMeta() {
        return this.output.getMeta();
    }

    public TextOutputOption addFilter(IFilter<TextRecord> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public TextOutputOption addFilters(Iterable<IFilter<TextRecord>> filters) {
        if (filters != null) {
            for (IFilter<TextRecord> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public TextOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<TextRecord> getWriters(int nParts) throws IOException {
        final TextWriter writers = this.output.instance(nParts);
        return new OutputConsumer<TextRecord>(){

            @Override
            public int write(int index, TextRecord input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (TextOutputOption.this.filters.size() > 0) {
                    for (IFilter<TextRecord> filter : TextOutputOption.this.filters) {
                        if (filter.filter(input)) continue;
                        return 0;
                    }
                }
                writers.write(index, input);
                return 1;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public void close() throws IOException {
                writers.close();
            }
        };
    }

    public TextOutputOption dropDuplicateMeta() {
        this.output.dropDuplicateMetas();
        return this;
    }

    public TextOutputOption clearMeta() {
        this.output.clearMetas();
        return this;
    }

    public TextOutputOption addMeta(CCFMetaItem meta) {
        this.output.addMeta(meta);
        return this;
    }

    public TextOutputOption addMeta(String key) {
        this.output.addMeta(key);
        return this;
    }

    public TextOutputOption addMeta(String key, String value) {
        this.output.addMeta(key, value);
        return this;
    }

    public TextOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.output.addMeta(meta);
        return this;
    }
}

