/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.toolkit.output;

import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.output.OutputConsumer;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFWriter;
import java.io.File;
import java.io.IOException;

public class VCFOutputOption
implements OutputOption<Variant, String> {
    final VCFWriter.Builder output;
    final IndexableSet<String> fields = List.wrap("ID", "QUAL", "FILTER", "INFO", "FORMAT").toIndexableSet().asUnmodifiable();
    final List<IFilter<Variant>> filters = new List();

    public VCFOutputOption() {
        this.output = VCFWriter.stdout();
    }

    public VCFOutputOption(String path) {
        this.output = VCFWriter.setOutput(path);
    }

    public VCFOutputOption(File path) {
        this.output = VCFWriter.setOutput(path);
    }

    public VCFOutputOption setCompressionLevel(int level) {
        this.output.setCompressionLevel(level);
        return this;
    }

    public int getCompressorLevel() {
        return this.output.getCompressorLevel();
    }

    public boolean isCompressionEnabled() {
        return this.output.isCompressionEnabled();
    }

    public VCFOutputOption clearIndividuals() {
        this.output.clearIndividuals();
        return this;
    }

    public VCFOutputOption addIndividual(String individual) {
        this.output.addIndividual(individual);
        return this;
    }

    public VCFOutputOption addIndividuals(String ... individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public VCFOutputOption addIndividuals(Iterable<String> individuals) {
        this.output.addIndividuals(individuals);
        return this;
    }

    public IndexableSet<String> getIndividuals() {
        return this.output.getIndividuals();
    }

    public VCFOutputOption setIndividuals(Iterable<String> individuals) {
        this.output.setIndividuals(individuals);
        return this;
    }

    public int numOfIndividuals() {
        return this.output.numOfIndividuals();
    }

    @Override
    public String getFile() {
        return this.output.getFile() == null ? null : this.output.getFile().getPath();
    }

    @Override
    public IndexableSet<String> getAllFields() {
        return this.fields;
    }

    public VCFOutputOption addFilter(IFilter<Variant> filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public VCFOutputOption addFilters(Iterable<IFilter<Variant>> filters) {
        if (filters != null) {
            for (IFilter<Variant> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
        }
        return this;
    }

    public VCFOutputOption clearFilters() {
        this.filters.clear();
        return this;
    }

    @Override
    public OutputConsumer<Variant> getWriters(int nParts) throws IOException {
        final VCFWriter writers = this.output.instance(nParts);
        return new OutputConsumer<Variant>(){

            @Override
            public int write(int index, Variant input) throws IOException {
                if (input == null) {
                    return 0;
                }
                if (VCFOutputOption.this.filters.size() > 0) {
                    for (IFilter<Variant> filter : VCFOutputOption.this.filters) {
                        if (filter.filter(input)) continue;
                        return 0;
                    }
                }
                writers.write(index, input);
                return 1;
            }

            @Override
            public void finish(int index) throws IOException {
                writers.finish(index);
            }

            @Override
            public int numOfParts() {
                return writers.numOfParts();
            }

            @Override
            public void close() throws IOException {
                writers.close();
            }
        };
    }

    public VCFOutputOption dropDuplicateMeta() {
        this.output.dropDuplicateMeta();
        return this;
    }

    public VCFOutputOption clearMeta() {
        this.output.clearMetas();
        return this;
    }

    public VCFOutputOption addMeta(CCFMetaItem meta) {
        this.output.addMeta(meta);
        return this;
    }

    public VCFOutputOption addMeta(String key) {
        this.output.addMeta(key);
        return this;
    }

    public VCFOutputOption addMeta(String key, String value) {
        this.output.addMeta(key, value);
        return this;
    }

    public VCFOutputOption addMeta(Iterable<CCFMetaItem> meta) {
        this.output.addMeta(meta);
        return this;
    }
}

