/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type;

import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import java.util.LinkedHashMap;

enum FieldTypeLoader {
    INSTANCE;

    private final LinkedHashMap<String, IFieldType> fields = new LinkedHashMap();

    public static IFieldType get(String key) {
        if (!FieldTypeLoader.INSTANCE.fields.containsKey(key)) {
            throw new RuntimeException("The field type '" + key + "' was not initialized. Available field type: " + FieldTypeLoader.INSTANCE.fields.keySet());
        }
        return FieldTypeLoader.INSTANCE.fields.get(key);
    }

    public static boolean contains(String key) {
        return FieldTypeLoader.INSTANCE.fields.containsKey(key);
    }

    public static synchronized void add(IFieldType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (FieldTypeLoader.INSTANCE.fields.containsKey(type.getName())) {
            throw new RuntimeException("The field type '" + type.getName() + "' has been initialized");
        }
        FieldTypeLoader.INSTANCE.fields.put(type.getName(), type);
    }

    static {
        for (FieldType type : FieldType.values()) {
            FieldTypeLoader.add(type);
        }
    }
}

