/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.array;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.ccf.type.decoder.DynamicLengthDecoder;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TIntIterator;

public class Int32ArrayBox
extends GenericBox<IntArray, Int32ArrayBox> {
    @Override
    public Int32ArrayBox set(int value) {
        this.value = new IntArray(1);
        ((IntArray)this.value).set(0, value);
        return this;
    }

    @Override
    public Int32ArrayBox set(int[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new IntArray(value);
        }
        return this;
    }

    @Override
    public Int32ArrayBox newInstance() {
        return new Int32ArrayBox();
    }

    @Override
    public Int32ArrayBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        IntArray returns = new IntArray(ValueUtils.count(chars, ',') + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, Integer.parseInt(values2.next()));
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public Int32ArrayBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        IntArray returns = new IntArray(chars.valueCount((byte)44) + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, values2.next().toInt());
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public Decoder<? extends Box<?, ?>> getDecoder() {
        return DynamicLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((IntArray)this.value).length());
        int lastValue = 0;
        int l = ((IntArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            int value = ((IntArray)this.value).get(i);
            length += container.putVarInt32(value - lastValue);
            lastValue = value;
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((IntArray)this.value).length());
        int lastValue = 0;
        int l = ((IntArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            int value = ((IntArray)this.value).get(i);
            container.putVarInt32(value - lastValue);
            lastValue = value;
        }
        return container.toBytes(true);
    }

    @Override
    public Int32ArrayBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        IntArray returns = new IntArray(size);
        int lastValue = 0;
        for (int i = 0; i < size; ++i) {
            int value = lastValue + reader.getVarInt32();
            returns.set(i, value);
            lastValue = value;
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((IntArray)this.value).length() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TIntIterator iterator2 = ((IntArray)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

