/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.array;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.ccf.type.decoder.DynamicLengthDecoder;
import edu.sysu.pmglab.container.array.ByteArray;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TByteIterator;

public class Int8ArrayBox
extends GenericBox<ByteArray, Int8ArrayBox> {
    @Override
    public Int8ArrayBox set(byte value) {
        this.value = new ByteArray(1);
        ((ByteArray)this.value).set(0, value);
        return this;
    }

    @Override
    public Int8ArrayBox set(byte[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new ByteArray(value);
        }
        return this;
    }

    @Override
    public Int8ArrayBox newInstance() {
        return new Int8ArrayBox();
    }

    @Override
    public Int8ArrayBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        ByteArray returns = new ByteArray(ValueUtils.count(chars, ',') + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, Byte.parseByte(values2.next()));
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public Int8ArrayBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        ByteArray returns = new ByteArray(chars.valueCount((byte)44) + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, values2.next().toByte());
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public Decoder<? extends Box<?, ?>> getDecoder() {
        return DynamicLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((ByteArray)this.value).length());
        int l = ((ByteArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            length += container.putByte(((ByteArray)this.value).get(i));
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((ByteArray)this.value).length());
        int l = ((ByteArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            container.putByte(((ByteArray)this.value).get(i));
        }
        return container.toBytes(true);
    }

    @Override
    public Int8ArrayBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        ByteArray returns = new ByteArray(size);
        for (int i = 0; i < size; ++i) {
            returns.set(i, reader.getByte());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((ByteArray)this.value).length() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        TByteIterator iterator2 = ((ByteArray)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

