/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.array;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.StringSplitter;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.ccf.type.decoder.DynamicLengthDecoder;
import edu.sysu.pmglab.container.array.StringArray;
import edu.sysu.pmglab.utils.ValueUtils;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class StringArrayBox
extends GenericBox<StringArray, StringArrayBox> {
    @Override
    public StringArrayBox set(String value) {
        this.value = new StringArray(1);
        ((StringArray)this.value).set(0, value);
        return this;
    }

    @Override
    public StringArrayBox set(String[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = new StringArray(value);
        }
        return this;
    }

    @Override
    public StringArrayBox newInstance() {
        return new StringArrayBox();
    }

    @Override
    public StringArrayBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        StringSplitter values2 = new StringSplitter(',').init(chars);
        StringArray returns = new StringArray(ValueUtils.count(chars, ',') + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, values2.next());
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public StringArrayBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        BytesSplitter values2 = new BytesSplitter(44).init(chars);
        StringArray returns = new StringArray(chars.valueCount((byte)44) + 1);
        int index = 0;
        while (values2.hasNext()) {
            returns.set(index++, values2.next().toString(StandardCharsets.UTF_8));
        }
        values2.clear();
        returns.setLength(index);
        this.value = returns;
        return this;
    }

    @Override
    public Decoder<? extends Box<?, ?>> getDecoder() {
        return DynamicLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        int length = container.putVarInt32(((StringArray)this.value).length());
        int l = ((StringArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            length += container.putString(((StringArray)this.value).get(i), true);
        }
        return length;
    }

    @Override
    public Bytes encode() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putVarInt32(((StringArray)this.value).length());
        int l = ((StringArray)this.value).length();
        for (int i = 0; i < l; ++i) {
            container.putString(((StringArray)this.value).get(i), true);
        }
        return container.toBytes(true);
    }

    @Override
    public StringArrayBox decode(Bytes container) {
        if (container.length() == 0) {
            this.init();
            return this;
        }
        ByteStream reader = container.toByteStream();
        int size = reader.getVarInt32();
        StringArray returns = new StringArray(size);
        for (int i = 0; i < size; ++i) {
            returns.set(i, reader.getString());
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        this.value = returns.asUnmodifiable();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null || ((StringArray)this.value).length() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream builder = ((ByteStream)temps.get()).clear();
        Iterator<String> iterator2 = ((StringArray)this.value).iterator();
        boolean next = false;
        while (iterator2.hasNext()) {
            if (next) {
                builder.write(44);
            } else {
                next = true;
            }
            builder.writeChar(iterator2.next());
        }
        return builder.toBytes(true);
    }
}

