/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.PrimitiveBox;
import edu.sysu.pmglab.ccf.type.decoder.BooleanDecoder;
import edu.sysu.pmglab.ccf.type.decoder.Decoder;
import edu.sysu.pmglab.ccf.type.encoder.BooleanEncoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;

public class BooleanBox
extends PrimitiveBox<Boolean, BooleanBox> {
    private static final Bytes TRUE = new Bytes("true");
    private static final Bytes FALSE = new Bytes("false");
    private boolean value = false;

    @Override
    public BooleanBox newInstance() {
        return new BooleanBox();
    }

    @Override
    public BooleanBox init() {
        this.value = false;
        return this;
    }

    @Override
    public BooleanBox set(Boolean value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value;
        }
        return this;
    }

    @Override
    public BooleanBox setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == BooleanBox.class ? ((BooleanBox)otherBox).value : (Boolean)otherBox.get();
        return this;
    }

    @Override
    public Boolean get() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BooleanBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        if (chars.length() == 1) {
            if (chars.equalsIgnoreCase("T")) {
                this.value = true;
                return this;
            } else {
                if (!chars.equalsIgnoreCase("F")) throw new NumberFormatException("Failed to convert '" + this + "' to a boolean value");
                this.value = false;
            }
            return this;
        } else if (chars.equalsIgnoreCase("true")) {
            this.value = true;
            return this;
        } else {
            if (!chars.equalsIgnoreCase("false")) throw new NumberFormatException("Failed to convert '" + this + "' to a boolean value");
            this.value = false;
        }
        return this;
    }

    @Override
    public BooleanBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toBoolean();
        return this;
    }

    @Override
    public Encoder<BooleanBox> getEncoder() {
        return new BooleanEncoder();
    }

    @Override
    public Decoder<BooleanBox> getDecoder() {
        return BooleanDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putBoolean(this.value);
    }

    @Override
    public Bytes encode() {
        if (this.value) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public BooleanBox decode(Bytes container) {
        this.value = container.decodeBoolean();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public String toString() {
        if (this.value) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    @Override
    public BooleanBox set(boolean value) {
        this.value = value;
        return this;
    }

    public boolean booleanValue() {
        return this.value;
    }
}

