/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.GenericBox;

public class BytesBox
extends GenericBox<Bytes, BytesBox> {
    @Override
    public BytesBox set(String value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.length() == 0 ? Bytes.EMPTY : new Bytes(value);
        }
        return this;
    }

    @Override
    public BytesBox setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.toBytes();
        return this;
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null) {
            return Bytes.EMPTY;
        }
        return (Bytes)this.value;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return ((Bytes)this.value).toString();
    }

    @Override
    public BytesBox set(byte[] value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.length == 0 ? Bytes.EMPTY : (value.length == 1 ? Bytes.byteToBytes(value[0]) : new Bytes(value));
        }
        return this;
    }

    @Override
    public BytesBox newInstance() {
        return new BytesBox();
    }

    @Override
    public BytesBox char2Object(String chars) {
        if (chars == null) {
            this.init();
            return this;
        }
        this.value = chars.length() == 0 ? Bytes.EMPTY : new Bytes(chars);
        return this;
    }

    @Override
    public BytesBox char2Object(Bytes chars, boolean detach) {
        if (chars == null) {
            this.init();
            return this;
        }
        this.value = detach ? chars.detach() : chars;
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null) {
            return 0;
        }
        return container.write((Bytes)this.value);
    }

    @Override
    public Bytes encode() {
        if (this.value == null || ((Bytes)this.value).length() == 0) {
            return Bytes.EMPTY;
        }
        return (Bytes)this.value;
    }

    @Override
    public BytesBox decode(Bytes container) {
        this.value = container.detach();
        return this;
    }
}

