/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.PrimitiveBox;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;

public class ChromosomeBox
extends PrimitiveBox<Chromosome, ChromosomeBox> {
    private Chromosome value = Chromosome.UNKNOWN;

    @Override
    public ChromosomeBox newInstance() {
        return new ChromosomeBox();
    }

    @Override
    public ChromosomeBox init() {
        this.value = Chromosome.UNKNOWN;
        return this;
    }

    @Override
    public ChromosomeBox set(Chromosome value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value;
        }
        return this;
    }

    @Override
    public ChromosomeBox setValueFrom(Box<?, ?> otherBox) {
        this.value = (Chromosome)otherBox.get();
        return this;
    }

    @Override
    public Chromosome get() {
        return this.value;
    }

    @Override
    public ChromosomeBox char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Chromosome.get(chars);
        return this;
    }

    @Override
    public int encodeTo(ByteStream container) {
        if (this.value == null || this.value == Chromosome.UNKNOWN) {
            return 0;
        }
        return container.write(this.toBytes());
    }

    @Override
    public Bytes encode() {
        if (this.value == null || this.value == Chromosome.UNKNOWN) {
            return Bytes.EMPTY;
        }
        return this.toBytes();
    }

    @Override
    public Bytes toBytes() {
        if (this.value == null) {
            this.value = Chromosome.UNKNOWN;
        }
        return this.value.toBytes();
    }

    @Override
    public ChromosomeBox char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Chromosome.get(chars.toString());
        return this;
    }

    @Override
    public ChromosomeBox decode(Bytes container) {
        if (container.length() == 0) {
            this.value = Chromosome.UNKNOWN;
            return this;
        }
        this.value = Chromosome.get(container.toString());
        return this;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public ChromosomeBox set(String value) {
        this.value = value == null ? Chromosome.UNKNOWN : Chromosome.get(value);
        return this;
    }

    @Override
    public ChromosomeBox set(int chromosomeIndex) {
        this.value = Chromosome.get(chromosomeIndex);
        return this;
    }
}

