/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Float16Box
extends NumberBox<Float16Box> {
    private float value = Float.NaN;

    @Override
    public Float16Box newInstance() {
        return new Float16Box();
    }

    @Override
    public Float16Box init() {
        this.value = Float.NaN;
        return this;
    }

    @Override
    public Float16Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.floatValue();
        }
        return this;
    }

    @Override
    public Float16Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Float16Box.class ? ((Float16Box)otherBox).value : ((Float)otherBox.get()).floatValue();
        return this;
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public Float16Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Float.parseFloat(chars);
        return this;
    }

    @Override
    public final Float16Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toFloat();
        return this;
    }

    @Override
    public FixedLengthEncoder<Float16Box> getEncoder() {
        return new FixedLengthEncoder<Float16Box>(2);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream output) {
        return output.putHalfFloat(this.value);
    }

    @Override
    public Bytes encode() {
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putHalfFloat(this.value);
        return container.toBytes(true);
    }

    @Override
    public Float16Box decode(Bytes container) {
        this.value = container.decodeHalfFloat();
        return this;
    }

    @Override
    public Bytes toBytes() {
        ByteStream builder = ((ByteStream)temps.get()).clear();
        builder.writeChar(this.value);
        return builder.toBytes(true);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float16Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Float16Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Float16Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public Float16Box set(long value) {
        this.value = value;
        return this;
    }

    @Override
    public Float16Box set(float value) {
        this.value = value;
        return this;
    }

    @Override
    public Float16Box set(double value) {
        this.value = (float)value;
        return this;
    }
}

