/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Float64Box
extends NumberBox<Float64Box> {
    private double value = Double.NaN;

    @Override
    public Float64Box newInstance() {
        return new Float64Box();
    }

    @Override
    public Float64Box init() {
        this.value = Double.NaN;
        return this;
    }

    @Override
    public Float64Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.doubleValue();
        }
        return this;
    }

    @Override
    public Float64Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Float64Box.class ? ((Float64Box)otherBox).value : (Double)otherBox.get();
        return this;
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public Float64Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Double.parseDouble(chars);
        return this;
    }

    @Override
    public final Float64Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toDouble();
        return this;
    }

    @Override
    public FixedLengthEncoder<Float64Box> getEncoder() {
        return new FixedLengthEncoder<Float64Box>(8);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putDouble(this.value);
    }

    @Override
    public Bytes encode() {
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putHalfFloat(this.value);
        return container.toBytes(true);
    }

    @Override
    public Float64Box decode(Bytes container) {
        this.value = container.decodeDouble();
        return this;
    }

    @Override
    public Bytes toBytes() {
        ByteStream builder = ((ByteStream)temps.get()).clear();
        builder.writeChar(this.value);
        return builder.toBytes(true);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float64Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Float64Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Float64Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public Float64Box set(long value) {
        this.value = value;
        return this;
    }

    @Override
    public Float64Box set(float value) {
        this.value = value;
        return this;
    }

    @Override
    public Float64Box set(double value) {
        this.value = value;
        return this;
    }
}

