/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;
import edu.sysu.pmglab.utils.Assert;

public class Float8Box
extends NumberBox<Float8Box> {
    private static final float[] values = new float[]{Float.NaN, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, -1.26f, -1.25f, -1.24f, -1.23f, -1.22f, -1.21f, -1.2f, -1.19f, -1.18f, -1.17f, -1.16f, -1.15f, -1.14f, -1.13f, -1.12f, -1.11f, -1.1f, -1.09f, -1.08f, -1.07f, -1.06f, -1.05f, -1.04f, -1.03f, -1.02f, -1.01f, -1.0f, -0.99f, -0.98f, -0.97f, -0.96f, -0.95f, -0.94f, -0.93f, -0.92f, -0.91f, -0.9f, -0.89f, -0.88f, -0.87f, -0.86f, -0.85f, -0.84f, -0.83f, -0.82f, -0.81f, -0.8f, -0.79f, -0.78f, -0.77f, -0.76f, -0.75f, -0.74f, -0.73f, -0.72f, -0.71f, -0.7f, -0.69f, -0.68f, -0.67f, -0.66f, -0.65f, -0.64f, -0.63f, -0.62f, -0.61f, -0.6f, -0.59f, -0.58f, -0.57f, -0.56f, -0.55f, -0.54f, -0.53f, -0.52f, -0.51f, -0.5f, -0.49f, -0.48f, -0.47f, -0.46f, -0.45f, -0.44f, -0.43f, -0.42f, -0.41f, -0.4f, -0.39f, -0.38f, -0.37f, -0.36f, -0.35f, -0.34f, -0.33f, -0.32f, -0.31f, -0.3f, -0.29f, -0.28f, -0.27f, -0.26f, -0.25f, -0.24f, -0.23f, -0.22f, -0.21f, -0.2f, -0.19f, -0.18f, -0.17f, -0.16f, -0.15f, -0.14f, -0.13f, -0.12f, -0.11f, -0.1f, -0.09f, -0.08f, -0.07f, -0.06f, -0.05f, -0.04f, -0.03f, -0.02f, -0.01f, 0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f, 1.01f, 1.02f, 1.03f, 1.04f, 1.05f, 1.06f, 1.07f, 1.08f, 1.09f, 1.1f, 1.11f, 1.12f, 1.13f, 1.14f, 1.15f, 1.16f, 1.17f, 1.18f, 1.19f, 1.2f, 1.21f, 1.22f, 1.23f, 1.24f, 1.25f, 1.26f};
    private float value = Float.NaN;

    public static byte floatToByteBits(float value) {
        int code;
        if (Float.isNaN(value)) {
            code = 0;
        } else if (value == Float.NEGATIVE_INFINITY) {
            code = 1;
        } else if (value == Float.POSITIVE_INFINITY) {
            code = 2;
        } else {
            if (value < -1.26f || value > 1.26f) {
                throw new NumberFormatException("Failed to convert '" + value + "' to a float8 value: value overflow");
            }
            code = (byte)(Math.round(value * 100.0f) + 129);
        }
        return (byte)code;
    }

    @Override
    public Float8Box newInstance() {
        return new Float8Box();
    }

    @Override
    public Float8Box init() {
        this.value = Float.NaN;
        return this;
    }

    @Override
    public Float8Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.floatValue();
        }
        return this;
    }

    @Override
    public Float8Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Float8Box.class ? ((Float8Box)otherBox).value : ((Float)otherBox.get()).floatValue();
        return this;
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public Float8Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Float.parseFloat(chars);
        return this;
    }

    @Override
    public final Float8Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toFloat();
        return this;
    }

    @Override
    public FixedLengthEncoder<Float8Box> getEncoder() {
        return new FixedLengthEncoder<Float8Box>(1);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream output) {
        return output.write(Float8Box.floatToByteBits(this.value));
    }

    @Override
    public Bytes encode() {
        return Bytes.byteToBytes(Float8Box.floatToByteBits(this.value));
    }

    @Override
    public Float8Box decode(Bytes container) {
        Assert.that(container.length() == 1);
        return this.decode(container.fastByteAt(0));
    }

    @Override
    public Bytes toBytes() {
        return new Bytes(ASCIIUtility.toASCII(this.value));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float8Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Float8Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Float8Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public Float8Box set(long value) {
        this.value = value;
        return this;
    }

    @Override
    public Float8Box set(float value) {
        this.value = value;
        return this;
    }

    @Override
    public Float8Box set(double value) {
        this.value = (float)value;
        return this;
    }

    public Float8Box decode(byte b) {
        this.value = values[b & 0xFF];
        return this;
    }
}

