/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Ing64Box
extends NumberBox<Ing64Box> {
    private long value = 0L;

    @Override
    public Ing64Box newInstance() {
        return new Ing64Box();
    }

    @Override
    public Ing64Box init() {
        this.value = 0L;
        return this;
    }

    @Override
    public Ing64Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.longValue();
        }
        return this;
    }

    @Override
    public Ing64Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Ing64Box.class ? ((Ing64Box)otherBox).value : (Long)otherBox.get();
        return this;
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public Ing64Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Long.parseLong(chars);
        return this;
    }

    @Override
    public Ing64Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toLong();
        return this;
    }

    @Override
    public Encoder<Ing64Box> getEncoder() {
        return new FixedLengthEncoder<Ing64Box>(8);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putLong(this.value);
    }

    @Override
    public Bytes encode() {
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putLong(this.value);
        return container.toBytes(true);
    }

    @Override
    public Ing64Box decode(Bytes container) {
        this.value = container.decodeLong();
        return this;
    }

    @Override
    public Bytes toBytes() {
        return new Bytes(ASCIIUtility.toASCII(this.value));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Ing64Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Ing64Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Ing64Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public Ing64Box set(long value) {
        this.value = value;
        return this;
    }

    @Override
    public Ing64Box set(float value) {
        this.value = (long)value;
        return this;
    }

    @Override
    public Ing64Box set(double value) {
        this.value = (long)value;
        return this;
    }
}

