/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Int16Box
extends NumberBox<Int16Box> {
    private short value = 0;

    @Override
    public Int16Box newInstance() {
        return new Int16Box();
    }

    @Override
    public Int16Box init() {
        this.value = 0;
        return this;
    }

    @Override
    public Int16Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.shortValue();
        }
        return this;
    }

    @Override
    public Int16Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Int16Box.class ? ((Int16Box)otherBox).value : (Short)otherBox.get();
        return this;
    }

    @Override
    public Short get() {
        return this.value;
    }

    @Override
    public Int16Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Short.parseShort(chars);
        return this;
    }

    @Override
    public Int16Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toShort();
        return this;
    }

    @Override
    public Encoder<Int16Box> getEncoder() {
        return new FixedLengthEncoder<Int16Box>(2);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putShort(this.value);
    }

    @Override
    public Bytes encode() {
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putShort(this.value);
        return container.toBytes(true);
    }

    @Override
    public Int16Box decode(Bytes container) {
        this.value = container.decodeShort();
        return this;
    }

    @Override
    public Bytes toBytes() {
        return new Bytes(ASCIIUtility.toASCII(this.value));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Int16Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Int16Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Int16Box set(int value) {
        this.value = (short)value;
        return this;
    }

    @Override
    public Int16Box set(long value) {
        this.value = (short)value;
        return this;
    }

    @Override
    public Int16Box set(float value) {
        this.value = (short)value;
        return this;
    }

    @Override
    public Int16Box set(double value) {
        this.value = (short)value;
        return this;
    }
}

