/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.type.basic;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.NumberBox;
import edu.sysu.pmglab.ccf.type.decoder.FixedLengthDecoder;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.ccf.type.encoder.FixedLengthEncoder;

public class Int32Box
extends NumberBox<Int32Box> {
    private int value = 0;

    @Override
    public Int32Box newInstance() {
        return new Int32Box();
    }

    @Override
    public Int32Box init() {
        this.value = 0;
        return this;
    }

    @Override
    public Int32Box set(Number value) {
        if (value == null) {
            this.init();
        } else {
            this.value = value.intValue();
        }
        return this;
    }

    @Override
    public Int32Box setValueFrom(Box<?, ?> otherBox) {
        this.value = otherBox.getClass() == Int32Box.class ? ((Int32Box)otherBox).value : (Integer)otherBox.get();
        return this;
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public Int32Box char2Object(String chars) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = Integer.parseInt(chars);
        return this;
    }

    @Override
    public Int32Box char2Object(Bytes chars, boolean detach) {
        if (chars == null || chars.length() == 0) {
            this.init();
            return this;
        }
        this.value = chars.toInt();
        return this;
    }

    @Override
    public Encoder<Int32Box> getEncoder() {
        return new FixedLengthEncoder<Int32Box>(4);
    }

    public FixedLengthDecoder getDecoder() {
        return FixedLengthDecoder.INSTANCE;
    }

    @Override
    public int encodeTo(ByteStream container) {
        return container.putInt(this.value);
    }

    @Override
    public Bytes encode() {
        ByteStream container = ((ByteStream)temps.get()).clear();
        container.putInt(this.value);
        return container.toBytes(true);
    }

    @Override
    public Int32Box decode(Bytes container) {
        this.value = container.decodeInt();
        return this;
    }

    @Override
    public Bytes toBytes() {
        return new Bytes(VarIntCodec.encode(this.value));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Int32Box set(byte value) {
        this.value = value;
        return this;
    }

    @Override
    public Int32Box set(short value) {
        this.value = value;
        return this;
    }

    @Override
    public Int32Box set(int value) {
        this.value = value;
        return this;
    }

    @Override
    public Int32Box set(long value) {
        this.value = (int)value;
        return this;
    }

    @Override
    public Int32Box set(float value) {
        this.value = (int)value;
        return this;
    }

    @Override
    public Int32Box set(double value) {
        this.value = (int)value;
        return this;
    }
}

